/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.webauthn4j.util.ArrayUtil;
import java.util.Arrays;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AuthenticationRequest {
    private final byte[] credentialId;
    private final byte[] userHandle;
    private final byte[] authenticatorData;
    private final byte[] clientDataJSON;
    private final String clientExtensionsJSON;
    private final byte[] signature;

    public AuthenticationRequest(@Nullable byte[] credentialId, @Nullable byte[] userHandle, @Nullable byte[] authenticatorData, @Nullable byte[] clientDataJSON, @Nullable String clientExtensionsJSON, @Nullable byte[] signature) {
        this.credentialId = ArrayUtil.clone((byte[])credentialId);
        this.userHandle = ArrayUtil.clone((byte[])userHandle);
        this.authenticatorData = ArrayUtil.clone((byte[])authenticatorData);
        this.clientDataJSON = ArrayUtil.clone((byte[])clientDataJSON);
        this.clientExtensionsJSON = clientExtensionsJSON;
        this.signature = ArrayUtil.clone((byte[])signature);
    }

    public AuthenticationRequest(@Nullable byte[] credentialId, @Nullable byte[] authenticatorData, @Nullable byte[] clientDataJSON, @Nullable String clientExtensionsJSON, @Nullable byte[] signature) {
        this(credentialId, null, authenticatorData, clientDataJSON, clientExtensionsJSON, signature);
    }

    public AuthenticationRequest(@Nullable byte[] credentialId, @Nullable byte[] userHandle, @Nullable byte[] authenticatorData, @Nullable byte[] clientDataJSON, @Nullable byte[] signature) {
        this(credentialId, userHandle, authenticatorData, clientDataJSON, null, signature);
    }

    public AuthenticationRequest(@Nullable byte[] credentialId, @Nullable byte[] authenticatorData, @Nullable byte[] clientDataJSON, @Nullable byte[] signature) {
        this(credentialId, null, authenticatorData, clientDataJSON, signature);
    }

    public @Nullable byte[] getCredentialId() {
        return ArrayUtil.clone((byte[])this.credentialId);
    }

    public @Nullable byte[] getUserHandle() {
        return ArrayUtil.clone((byte[])this.userHandle);
    }

    public @Nullable byte[] getAuthenticatorData() {
        return ArrayUtil.clone((byte[])this.authenticatorData);
    }

    public @Nullable byte[] getClientDataJSON() {
        return ArrayUtil.clone((byte[])this.clientDataJSON);
    }

    public @Nullable String getClientExtensionsJSON() {
        return this.clientExtensionsJSON;
    }

    public @Nullable byte[] getSignature() {
        return ArrayUtil.clone((byte[])this.signature);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationRequest that = (AuthenticationRequest)o;
        return Arrays.equals(this.credentialId, that.credentialId) && Arrays.equals(this.userHandle, that.userHandle) && Arrays.equals(this.authenticatorData, that.authenticatorData) && Arrays.equals(this.clientDataJSON, that.clientDataJSON) && Objects.equals(this.clientExtensionsJSON, that.clientExtensionsJSON) && Arrays.equals(this.signature, that.signature);
    }

    public int hashCode() {
        int result = Objects.hash(this.clientExtensionsJSON);
        result = 31 * result + Arrays.hashCode(this.credentialId);
        result = 31 * result + Arrays.hashCode(this.userHandle);
        result = 31 * result + Arrays.hashCode(this.authenticatorData);
        result = 31 * result + Arrays.hashCode(this.clientDataJSON);
        result = 31 * result + Arrays.hashCode(this.signature);
        return result;
    }

    public String toString() {
        return "AuthenticationRequest(credentialId=" + ArrayUtil.toHexString((byte[])this.credentialId) + ", userHandle=" + ArrayUtil.toHexString((byte[])this.userHandle) + ", authenticatorData=" + ArrayUtil.toHexString((byte[])this.authenticatorData) + ", clientDataJSON=" + ArrayUtil.toHexString((byte[])this.clientDataJSON) + ", clientExtensionsJSON=" + this.clientExtensionsJSON + ", signature=" + ArrayUtil.toHexString((byte[])this.signature) + ")";
    }
}

