/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.extension.authenticator;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.webauthn4j.converter.jackson.deserializer.cbor.HMACSecretAuthenticatorInputDeserializer;
import com.webauthn4j.data.extension.CredentialProtectionPolicy;
import com.webauthn4j.data.extension.SingleValueExtensionInputBase;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionAuthenticatorInput;
import com.webauthn4j.data.extension.authenticator.CredentialProtectionExtensionAuthenticatorInput;
import com.webauthn4j.data.extension.authenticator.ExtensionAuthenticatorInput;
import com.webauthn4j.data.extension.authenticator.HMACGetSecretAuthenticatorInput;
import com.webauthn4j.data.extension.authenticator.HMACSecretAuthenticationExtensionAuthenticatorInput;
import com.webauthn4j.data.extension.authenticator.HMACSecretRegistrationExtensionAuthenticatorInput;
import com.webauthn4j.data.extension.authenticator.RegistrationExtensionAuthenticatorInput;
import com.webauthn4j.data.extension.authenticator.UserVerificationMethodExtensionAuthenticatorInput;
import com.webauthn4j.util.AssertUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AuthenticationExtensionsAuthenticatorInputs<T extends ExtensionAuthenticatorInput>
implements Serializable {
    private static final String KEY_UVM = "uvm";
    private static final String KEY_CRED_PROTECT = "credProtect";
    private static final String KEY_HMAC_SECRET = "hmac-secret";
    @JsonIgnore
    private final Map<String, Serializable> unknowns = new HashMap<String, Serializable>();
    @JsonProperty
    private Boolean uvm;
    @JsonProperty
    private CredentialProtectionPolicy credProtect;
    @JsonIgnore
    private Boolean hmacCreateSecret;
    @JsonIgnore
    private HMACGetSecretAuthenticatorInput hmacGetSecret;
    @JsonIgnore
    private Map<Class<? extends T>, T> extensions;

    @JsonSetter(value="hmac-secret")
    @JsonDeserialize(using=HMACSecretAuthenticatorInputDeserializer.class)
    private void setHMACSecret(Object hmacSecret) {
        if (hmacSecret instanceof Boolean) {
            this.hmacCreateSecret = (Boolean)hmacSecret;
            this.hmacGetSecret = null;
        } else {
            this.hmacCreateSecret = null;
            this.hmacGetSecret = (HMACGetSecretAuthenticatorInput)hmacSecret;
        }
    }

    @JsonAnyGetter
    private Map<String, Serializable> getUnknowns() {
        return Collections.unmodifiableMap(this.unknowns);
    }

    @JsonAnySetter
    private void setUnknowns(@NonNull String name, @Nullable Serializable value) {
        this.unknowns.put(name, value);
    }

    @JsonIgnore
    public @NonNull Set<String> getKeys() {
        HashSet<String> keys = new HashSet<String>();
        if (this.uvm != null) {
            keys.add(KEY_UVM);
        }
        if (this.credProtect != null) {
            keys.add(KEY_CRED_PROTECT);
        }
        if (this.hmacCreateSecret != null) {
            keys.add(KEY_HMAC_SECRET);
        }
        if (this.hmacGetSecret != null) {
            keys.add(KEY_HMAC_SECRET);
        }
        keys.addAll(this.getUnknownKeys());
        return keys;
    }

    @JsonIgnore
    public @NonNull Set<String> getUnknownKeys() {
        return this.unknowns.keySet();
    }

    @JsonIgnore
    public @Nullable Object getValue(String key) {
        switch (key) {
            case "uvm": {
                return this.uvm;
            }
            case "credProtect": {
                return this.credProtect;
            }
            case "hmac-secret": {
                return this.hmacCreateSecret != null ? this.hmacCreateSecret : this.hmacGetSecret;
            }
        }
        return this.unknowns.get(key);
    }

    @JsonIgnore
    public @Nullable Boolean getUvm() {
        return this.uvm;
    }

    @JsonIgnore
    public @Nullable CredentialProtectionPolicy getCredProtect() {
        return this.credProtect;
    }

    @JsonGetter(value="hmac-secret")
    public @Nullable Object getHMACSecret() {
        return this.hmacCreateSecret != null ? this.hmacCreateSecret : this.hmacGetSecret;
    }

    @JsonIgnore
    public @Nullable Boolean getHMACCreateSecret() {
        return this.hmacCreateSecret;
    }

    @JsonIgnore
    public @Nullable HMACGetSecretAuthenticatorInput getHMACGetSecret() {
        return this.hmacGetSecret;
    }

    public <E extends T> @Nullable E getExtension(@NonNull Class<E> tClass) {
        return (E)((ExtensionAuthenticatorInput)this.getExtensions().get(tClass));
    }

    @JsonIgnore
    public @NonNull Map<Class<? extends T>, T> getExtensions() {
        if (this.extensions == null) {
            HashMap<Class, SingleValueExtensionInputBase> map = new HashMap<Class, SingleValueExtensionInputBase>();
            if (this.uvm != null) {
                map.put(UserVerificationMethodExtensionAuthenticatorInput.class, new UserVerificationMethodExtensionAuthenticatorInput(this.uvm));
            }
            if (this.credProtect != null) {
                map.put(CredentialProtectionExtensionAuthenticatorInput.class, new CredentialProtectionExtensionAuthenticatorInput(this.credProtect));
            }
            if (this.hmacCreateSecret != null) {
                map.put(HMACSecretRegistrationExtensionAuthenticatorInput.class, new HMACSecretRegistrationExtensionAuthenticatorInput(this.hmacCreateSecret));
            }
            if (this.hmacGetSecret != null) {
                map.put(HMACSecretAuthenticationExtensionAuthenticatorInput.class, new HMACSecretAuthenticationExtensionAuthenticatorInput(this.hmacGetSecret));
            }
            this.extensions = Collections.unmodifiableMap(map);
        }
        return this.extensions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationExtensionsAuthenticatorInputs that = (AuthenticationExtensionsAuthenticatorInputs)o;
        return Objects.equals(this.unknowns, that.unknowns) && Objects.equals(this.uvm, that.uvm) && this.credProtect == that.credProtect && Objects.equals(this.hmacCreateSecret, that.hmacCreateSecret) && Objects.equals(this.hmacGetSecret, that.hmacGetSecret) && Objects.equals(this.extensions, that.extensions);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AuthenticationExtensionsAuthenticatorInputs(");
        String entries = this.getExtensions().values().stream().map(t -> String.format("%s=%s", t.getIdentifier(), t)).collect(Collectors.joining(", "));
        builder.append(entries);
        String unknownsStr = this.getUnknowns().entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining(", "));
        if (!unknownsStr.isEmpty()) {
            builder.append(", ");
            builder.append(unknownsStr);
        }
        builder.append(")");
        return builder.toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.unknowns, this.uvm, this.credProtect, this.hmacCreateSecret, this.hmacGetSecret, this.extensions});
    }

    public static class BuilderForAuthentication {
        private final Map<String, Serializable> unknowns = new HashMap<String, Serializable>();
        private Boolean uvm;
        private HMACGetSecretAuthenticatorInput hmacGetSecret;

        public @NonNull AuthenticationExtensionsAuthenticatorInputs<AuthenticationExtensionAuthenticatorInput> build() {
            AuthenticationExtensionsAuthenticatorInputs<AuthenticationExtensionAuthenticatorInput> instance = new AuthenticationExtensionsAuthenticatorInputs<AuthenticationExtensionAuthenticatorInput>();
            ((AuthenticationExtensionsAuthenticatorInputs)instance).uvm = this.uvm;
            ((AuthenticationExtensionsAuthenticatorInputs)instance).hmacGetSecret = this.hmacGetSecret;
            ((AuthenticationExtensionsAuthenticatorInputs)instance).unknowns.putAll(this.unknowns);
            return instance;
        }

        public @NonNull BuilderForAuthentication setUvm(@Nullable Boolean uvm) {
            this.uvm = uvm;
            return this;
        }

        public @NonNull BuilderForAuthentication setHMACGetSecret(@Nullable HMACGetSecretAuthenticatorInput hmacGetSecret) {
            this.hmacGetSecret = hmacGetSecret;
            return this;
        }

        public @NonNull BuilderForAuthentication set(@NonNull String key, @Nullable Serializable value) {
            AssertUtil.notNull((Object)key, (String)"key must not be null.");
            AssertUtil.notNull((Object)value, (String)"value must not be null.");
            this.unknowns.put(key, value);
            return this;
        }
    }

    public static class BuilderForRegistration {
        private final Map<String, Serializable> unknowns = new HashMap<String, Serializable>();
        private Boolean uvm;
        private CredentialProtectionPolicy credProtect;
        private Boolean hmacCreateSecret;

        public @NonNull AuthenticationExtensionsAuthenticatorInputs<RegistrationExtensionAuthenticatorInput> build() {
            AuthenticationExtensionsAuthenticatorInputs<RegistrationExtensionAuthenticatorInput> instance = new AuthenticationExtensionsAuthenticatorInputs<RegistrationExtensionAuthenticatorInput>();
            ((AuthenticationExtensionsAuthenticatorInputs)instance).uvm = this.uvm;
            ((AuthenticationExtensionsAuthenticatorInputs)instance).credProtect = this.credProtect;
            ((AuthenticationExtensionsAuthenticatorInputs)instance).hmacCreateSecret = this.hmacCreateSecret;
            ((AuthenticationExtensionsAuthenticatorInputs)instance).unknowns.putAll(this.unknowns);
            return instance;
        }

        public @NonNull BuilderForRegistration setUvm(@Nullable Boolean uvm) {
            this.uvm = uvm;
            return this;
        }

        public @NonNull BuilderForRegistration setCredProtect(@Nullable CredentialProtectionPolicy credProtect) {
            this.credProtect = credProtect;
            return this;
        }

        public @NonNull BuilderForRegistration setHMACCreateSecret(@Nullable Boolean hmacCreateSecret) {
            this.hmacCreateSecret = hmacCreateSecret;
            return this;
        }

        public @NonNull BuilderForRegistration set(@NonNull String key, @Nullable Serializable value) {
            AssertUtil.notNull((Object)key, (String)"key must not be null.");
            AssertUtil.notNull((Object)value, (String)"value must not be null.");
            this.unknowns.put(key, value);
            return this;
        }
    }
}

