/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.webauthn4j.data.MessageDigestAlgorithm;
import java.io.Serializable;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SignatureAlgorithm
implements Serializable {
    public static final String SHA_256_WITH_ECDSA = "SHA256withECDSA";
    public static final String SHA_384_WITH_ECDSA = "SHA384withECDSA";
    public static final String SHA_512_WITH_ECDSA = "SHA512withECDSA";
    public static final String SHA_1_WITH_RSA = "SHA1withRSA";
    public static final String SHA_256_WITH_RSA = "SHA256withRSA";
    public static final String SHA_384_WITH_RSA = "SHA384withRSA";
    public static final String SHA_512_WITH_RSA = "SHA512withRSA";
    public static final SignatureAlgorithm ES256 = new SignatureAlgorithm("SHA256withECDSA", MessageDigestAlgorithm.SHA256);
    public static final SignatureAlgorithm ES384 = new SignatureAlgorithm("SHA384withECDSA", MessageDigestAlgorithm.SHA384);
    public static final SignatureAlgorithm ES512 = new SignatureAlgorithm("SHA512withECDSA", MessageDigestAlgorithm.SHA512);
    public static final SignatureAlgorithm RS1 = new SignatureAlgorithm("SHA1withRSA", MessageDigestAlgorithm.SHA1);
    public static final SignatureAlgorithm RS256 = new SignatureAlgorithm("SHA256withRSA", MessageDigestAlgorithm.SHA256);
    public static final SignatureAlgorithm RS384 = new SignatureAlgorithm("SHA384withRSA", MessageDigestAlgorithm.SHA384);
    public static final SignatureAlgorithm RS512 = new SignatureAlgorithm("SHA512withRSA", MessageDigestAlgorithm.SHA512);
    private final String jcaName;
    private final MessageDigestAlgorithm messageDigestAlgorithm;

    private SignatureAlgorithm(@NonNull String jcaName, @NonNull MessageDigestAlgorithm messageDigestAlgorithm) {
        this.jcaName = jcaName;
        this.messageDigestAlgorithm = messageDigestAlgorithm;
    }

    public static SignatureAlgorithm create(@NonNull String jcaName) {
        switch (jcaName) {
            case "SHA256withECDSA": {
                return ES256;
            }
            case "SHA384withECDSA": {
                return ES384;
            }
            case "SHA512withECDSA": {
                return ES512;
            }
            case "SHA1withRSA": {
                return RS1;
            }
            case "SHA256withRSA": {
                return RS256;
            }
            case "SHA384withRSA": {
                return RS384;
            }
            case "SHA512withRSA": {
                return RS512;
            }
        }
        throw new IllegalArgumentException(String.format("jcaName %s is not supported.", jcaName));
    }

    public static SignatureAlgorithm create(@NonNull String jcaName, @NonNull String messageDigestJcaName) {
        return new SignatureAlgorithm(jcaName, MessageDigestAlgorithm.create(messageDigestJcaName));
    }

    @JsonCreator
    private static @NonNull SignatureAlgorithm deserialize(String value) throws InvalidFormatException {
        try {
            return SignatureAlgorithm.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, SignatureAlgorithm.class);
        }
    }

    @JsonValue
    public @NonNull String getJcaName() {
        return this.jcaName;
    }

    public @NonNull MessageDigestAlgorithm getMessageDigestAlgorithm() {
        return this.messageDigestAlgorithm;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignatureAlgorithm that = (SignatureAlgorithm)o;
        return Objects.equals(this.jcaName, that.jcaName) && Objects.equals(this.messageDigestAlgorithm, that.messageDigestAlgorithm);
    }

    public int hashCode() {
        return Objects.hash(this.jcaName, this.messageDigestAlgorithm);
    }

    public String toString() {
        switch (this.jcaName) {
            case "SHA256withECDSA": {
                return "ES256";
            }
            case "SHA384withECDSA": {
                return "ES384";
            }
            case "SHA512withECDSA": {
                return "ES512";
            }
            case "SHA1withRSA": {
                return "RS1";
            }
            case "SHA256withRSA": {
                return "RS256";
            }
            case "SHA384withRSA": {
                return "RS384";
            }
            case "SHA512withRSA": {
                return "RS512";
            }
        }
        return "Unknown jcaName: " + this.jcaName;
    }
}

