/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.anchor;

import com.webauthn4j.anchor.KeyStoreException;
import com.webauthn4j.anchor.TrustAnchorRepository;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.CertificateUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;

public class KeyStoreTrustAnchorRepository
implements TrustAnchorRepository {
    private final Set<TrustAnchor> trustAnchors;

    public KeyStoreTrustAnchorRepository(KeyStore keyStore) {
        AssertUtil.notNull((Object)keyStore, (String)"keyStore must not be null");
        this.trustAnchors = KeyStoreTrustAnchorRepository.loadTrustAnchors(keyStore);
    }

    public KeyStoreTrustAnchorRepository(Path keyStore, String password) {
        this(KeyStoreTrustAnchorRepository.loadKeyStore(keyStore, password));
    }

    @Override
    public Set<TrustAnchor> find(AAGUID aaguid) {
        return this.trustAnchors;
    }

    @Override
    public Set<TrustAnchor> find(byte[] attestationCertificateKeyIdentifier) {
        return this.trustAnchors;
    }

    private static @NonNull Set<TrustAnchor> loadTrustAnchors(KeyStore keyStore) {
        try {
            ArrayList<String> aliases = Collections.list(keyStore.aliases());
            HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
            for (String alias : aliases) {
                X509Certificate certificate = (X509Certificate)keyStore.getCertificate(alias);
                trustAnchors.add(new TrustAnchor(certificate, null));
            }
            return trustAnchors;
        }
        catch (java.security.KeyStoreException e) {
            throw new KeyStoreException("Failed to load TrustAnchor from keystore", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static @NonNull KeyStore loadKeyStore(Path keyStore, String password) {
        AssertUtil.notNull((Object)keyStore, (String)"keyStore must not be null");
        AssertUtil.notNull((Object)password, (String)"password must not be null");
        try (InputStream inputStream = Files.newInputStream(keyStore, new OpenOption[0]);){
            KeyStore keyStoreObject = CertificateUtil.createKeyStore();
            keyStoreObject.load(inputStream, password.toCharArray());
            KeyStore keyStore2 = keyStoreObject;
            return keyStore2;
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            throw new KeyStoreException("Failed to load TrustAnchor from keystore", e);
        }
    }
}

