/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.data.client.TokenBindingStatus;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.Base64UrlUtil;
import java.io.Serializable;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TokenBinding
implements Serializable {
    private final @NonNull TokenBindingStatus status;
    private final @Nullable String id;

    @JsonCreator
    public TokenBinding(@JsonProperty(value="status") @NonNull TokenBindingStatus status, @JsonProperty(value="id") @Nullable String id) {
        AssertUtil.notNull((Object)((Object)status), (String)"status must not be null");
        this.status = status;
        this.id = id;
    }

    public TokenBinding(@NonNull TokenBindingStatus status, @Nullable byte[] id) {
        AssertUtil.notNull((Object)((Object)status), (String)"status must not be null");
        this.status = status;
        this.id = id == null ? null : Base64UrlUtil.encodeToString((byte[])id);
    }

    public @NonNull TokenBindingStatus getStatus() {
        return this.status;
    }

    public @Nullable String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenBinding that = (TokenBinding)o;
        return this.status == that.status && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.id});
    }

    public String toString() {
        return "TokenBinding(status=" + (Object)((Object)this.status) + ", id=" + this.id + ')';
    }
}

