/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import org.checkerframework.checker.nullness.qual.NonNull;

public enum MatcherProtectionType {
    SOFTWARE(1),
    TEE(2),
    ON_CHIP(4);

    private final int value;

    private MatcherProtectionType(int value) {
        this.value = value;
    }

    public static @NonNull MatcherProtectionType create(int value) {
        if (value > 65535 || value < 0) {
            throw new IllegalArgumentException("value '" + value + "' is out of range");
        }
        switch (value) {
            case 1: {
                return SOFTWARE;
            }
            case 2: {
                return TEE;
            }
            case 4: {
                return ON_CHIP;
            }
        }
        throw new IllegalArgumentException("value '" + value + "' is out of range");
    }

    @JsonCreator
    private static @NonNull MatcherProtectionType deserialize(int value) throws InvalidFormatException {
        try {
            return MatcherProtectionType.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, MatcherProtectionType.class);
        }
    }

    @JsonValue
    public int getValue() {
        return this.value;
    }

    public String toString() {
        switch (this.value) {
            case 1: {
                return "SOFTWARE";
            }
            case 2: {
                return "TEE";
            }
            case 4: {
                return "ON_CHIP";
            }
        }
        return "UNKNOWN(" + String.format("%04X", this.value) + ")";
    }
}

