/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.webauthn4j.data.AuthenticatorAttachment;
import com.webauthn4j.data.extension.CredentialProtectionPolicy;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.NonNull;

public class CredentialProtectionPolicyStringDeserializer
extends StdDeserializer<CredentialProtectionPolicy> {
    protected CredentialProtectionPolicyStringDeserializer() {
        super(CredentialProtectionPolicy.class);
    }

    public @NonNull CredentialProtectionPolicy deserialize(@NonNull JsonParser p, @NonNull DeserializationContext ctxt) throws IOException {
        String value = p.getValueAsString();
        try {
            return CredentialProtectionPolicy.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, AuthenticatorAttachment.class);
        }
    }
}

