/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.webauthn4j.data.SignatureAlgorithm;
import com.webauthn4j.data.attestation.statement.COSEKeyType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class COSEAlgorithmIdentifier
implements Serializable {
    public static final COSEAlgorithmIdentifier RS1;
    public static final COSEAlgorithmIdentifier RS256;
    public static final COSEAlgorithmIdentifier RS384;
    public static final COSEAlgorithmIdentifier RS512;
    public static final COSEAlgorithmIdentifier ES256;
    public static final COSEAlgorithmIdentifier ES384;
    public static final COSEAlgorithmIdentifier ES512;
    private static final Map<COSEAlgorithmIdentifier, COSEKeyType> keyTypeMap;
    private static final Map<COSEAlgorithmIdentifier, SignatureAlgorithm> algorithmMap;
    private static final Map<SignatureAlgorithm, COSEAlgorithmIdentifier> reverseAlgorithmMap;
    private final long value;

    COSEAlgorithmIdentifier(long value) {
        this.value = value;
    }

    public static @NonNull COSEAlgorithmIdentifier create(long value) {
        return new COSEAlgorithmIdentifier(value);
    }

    public static @NonNull COSEAlgorithmIdentifier create(@NonNull SignatureAlgorithm signatureAlgorithm) {
        COSEAlgorithmIdentifier coseAlgorithmIdentifier = reverseAlgorithmMap.get(signatureAlgorithm);
        if (coseAlgorithmIdentifier == null) {
            throw new IllegalArgumentException(String.format("SignatureAlgorithm %s is not supported.", signatureAlgorithm.getJcaName()));
        }
        return coseAlgorithmIdentifier;
    }

    @JsonCreator
    private static @NonNull COSEAlgorithmIdentifier deserialize(long value) throws InvalidFormatException {
        try {
            return COSEAlgorithmIdentifier.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, COSEAlgorithmIdentifier.class);
        }
    }

    @JsonValue
    public long getValue() {
        return this.value;
    }

    @JsonIgnore
    public @NonNull COSEKeyType getKeyType() {
        COSEKeyType coseKeyType = keyTypeMap.get(this);
        if (coseKeyType == null) {
            throw new IllegalArgumentException(String.format("COSEAlgorithmIdentifier %d is unknown.", this.getValue()));
        }
        return coseKeyType;
    }

    public @NonNull SignatureAlgorithm toSignatureAlgorithm() {
        SignatureAlgorithm signatureAlgorithm = algorithmMap.get(this);
        if (signatureAlgorithm == null) {
            throw new IllegalArgumentException(String.format("COSEAlgorithmIdentifier %d is unknown.", this.getValue()));
        }
        return signatureAlgorithm;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        COSEAlgorithmIdentifier that = (COSEAlgorithmIdentifier)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    static {
        keyTypeMap = new HashMap<COSEAlgorithmIdentifier, COSEKeyType>();
        algorithmMap = new HashMap<COSEAlgorithmIdentifier, SignatureAlgorithm>();
        reverseAlgorithmMap = new HashMap<SignatureAlgorithm, COSEAlgorithmIdentifier>();
        RS1 = new COSEAlgorithmIdentifier(-65535L);
        RS256 = new COSEAlgorithmIdentifier(-257L);
        RS384 = new COSEAlgorithmIdentifier(-258L);
        RS512 = new COSEAlgorithmIdentifier(-259L);
        ES256 = new COSEAlgorithmIdentifier(-7L);
        ES384 = new COSEAlgorithmIdentifier(-35L);
        ES512 = new COSEAlgorithmIdentifier(-36L);
        keyTypeMap.put(ES256, COSEKeyType.EC2);
        keyTypeMap.put(ES384, COSEKeyType.EC2);
        keyTypeMap.put(ES512, COSEKeyType.EC2);
        keyTypeMap.put(RS1, COSEKeyType.RSA);
        keyTypeMap.put(RS256, COSEKeyType.RSA);
        keyTypeMap.put(RS384, COSEKeyType.RSA);
        keyTypeMap.put(RS512, COSEKeyType.RSA);
        algorithmMap.put(ES256, SignatureAlgorithm.ES256);
        algorithmMap.put(ES384, SignatureAlgorithm.ES384);
        algorithmMap.put(ES512, SignatureAlgorithm.ES512);
        algorithmMap.put(RS1, SignatureAlgorithm.RS1);
        algorithmMap.put(RS256, SignatureAlgorithm.RS256);
        algorithmMap.put(RS384, SignatureAlgorithm.RS384);
        algorithmMap.put(RS512, SignatureAlgorithm.RS512);
        for (Map.Entry<COSEAlgorithmIdentifier, SignatureAlgorithm> entry : algorithmMap.entrySet()) {
            reverseAlgorithmMap.put(entry.getValue(), entry.getKey());
        }
    }
}

