/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.webauthn4j.converter.jackson.JacksonUtil;
import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.server.CoreServerProperty;
import com.webauthn4j.util.ArrayUtil;
import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;

public class CoreRegistrationObject {
    private static final ObjectMapper cborMapper = new ObjectMapper((JsonFactory)new CBORFactory());
    private final AttestationObject attestationObject;
    private final byte[] attestationObjectBytes;
    private final byte[] clientDataHash;
    private final CoreServerProperty serverProperty;
    private final Instant timestamp;

    public CoreRegistrationObject(AttestationObject attestationObject, byte[] attestationObjectBytes, byte[] clientDataHash, CoreServerProperty serverProperty, Instant timestamp) {
        this.attestationObject = attestationObject;
        this.attestationObjectBytes = attestationObjectBytes;
        this.clientDataHash = clientDataHash;
        this.serverProperty = serverProperty;
        this.timestamp = timestamp;
    }

    public CoreRegistrationObject(AttestationObject attestationObject, byte[] attestationObjectBytes, byte[] clientDataHash, CoreServerProperty serverProperty) {
        this(attestationObject, attestationObjectBytes, clientDataHash, serverProperty, Instant.now());
    }

    public AttestationObject getAttestationObject() {
        return this.attestationObject;
    }

    public byte[] getAttestationObjectBytes() {
        return ArrayUtil.clone((byte[])this.attestationObjectBytes);
    }

    public byte[] getAuthenticatorDataBytes() {
        return CoreRegistrationObject.extractAuthenticatorData(this.attestationObjectBytes);
    }

    public byte[] getClientDataHash() {
        return this.clientDataHash;
    }

    public CoreServerProperty getServerProperty() {
        return this.serverProperty;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoreRegistrationObject that = (CoreRegistrationObject)o;
        return Objects.equals(this.attestationObject, that.attestationObject) && Arrays.equals(this.attestationObjectBytes, that.attestationObjectBytes) && Arrays.equals(this.clientDataHash, that.clientDataHash) && Objects.equals(this.serverProperty, that.serverProperty) && Objects.equals(this.timestamp, that.timestamp);
    }

    public int hashCode() {
        int result = Objects.hash(this.attestationObject, this.serverProperty, this.timestamp);
        result = 31 * result + Arrays.hashCode(this.attestationObjectBytes);
        result = 31 * result + Arrays.hashCode(this.clientDataHash);
        return result;
    }

    private static byte[] extractAuthenticatorData(byte[] attestationObject) {
        return JacksonUtil.binaryValue(JacksonUtil.readTree(cborMapper, attestationObject).get("authData"));
    }
}

