/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator;

import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.CoreRegistrationData;
import com.webauthn4j.data.CoreRegistrationParameters;
import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionsAuthenticatorOutputs;
import com.webauthn4j.data.extension.authenticator.RegistrationExtensionAuthenticatorOutput;
import com.webauthn4j.server.CoreServerProperty;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.validator.AttestationValidator;
import com.webauthn4j.validator.AuthenticatorExtensionValidator;
import com.webauthn4j.validator.BeanAssertUtil;
import com.webauthn4j.validator.CoreRegistrationObject;
import com.webauthn4j.validator.CustomCoreRegistrationValidator;
import com.webauthn4j.validator.RpIdHashValidator;
import com.webauthn4j.validator.attestation.statement.AttestationStatementValidator;
import com.webauthn4j.validator.attestation.trustworthiness.certpath.CertPathTrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.self.SelfAttestationTrustworthinessValidator;
import com.webauthn4j.validator.exception.ConstraintViolationException;
import com.webauthn4j.validator.exception.UserNotPresentException;
import com.webauthn4j.validator.exception.UserNotVerifiedException;
import java.util.List;

public class CoreRegistrationDataValidator {
    private final RpIdHashValidator rpIdHashValidator = new RpIdHashValidator();
    private final AuthenticatorExtensionValidator authenticatorExtensionValidator = new AuthenticatorExtensionValidator();
    private List<CustomCoreRegistrationValidator> customRegistrationValidators;
    private final AttestationValidator attestationValidator;

    public CoreRegistrationDataValidator(List<AttestationStatementValidator> attestationStatementValidators, CertPathTrustworthinessValidator certPathTrustworthinessValidator, SelfAttestationTrustworthinessValidator selfAttestationTrustworthinessValidator, List<CustomCoreRegistrationValidator> customRegistrationValidators, ObjectConverter objectConverter) {
        AssertUtil.notNull(attestationStatementValidators, (String)"attestationStatementValidators must not be null");
        AssertUtil.notNull((Object)certPathTrustworthinessValidator, (String)"certPathTrustworthinessValidator must not be null");
        AssertUtil.notNull((Object)selfAttestationTrustworthinessValidator, (String)"selfAttestationTrustworthinessValidator must not be null");
        AssertUtil.notNull(customRegistrationValidators, (String)"customRegistrationValidators must not be null");
        AssertUtil.notNull((Object)objectConverter, (String)"objectConverter must not be null");
        this.attestationValidator = new AttestationValidator(attestationStatementValidators, certPathTrustworthinessValidator, selfAttestationTrustworthinessValidator);
        this.customRegistrationValidators = customRegistrationValidators;
    }

    public void validate(CoreRegistrationData registrationData, CoreRegistrationParameters registrationParameters) {
        BeanAssertUtil.validate(registrationData);
        BeanAssertUtil.validate(registrationParameters);
        AttestationObject attestationObject = registrationData.getAttestationObject();
        this.validateAuthenticatorDataField(attestationObject.getAuthenticatorData());
        CoreServerProperty serverProperty = registrationParameters.getServerProperty();
        CoreRegistrationObject registrationObject = this.createCoreRegistrationObject(registrationData, registrationParameters);
        AuthenticatorData<RegistrationExtensionAuthenticatorOutput> authenticatorData = attestationObject.getAuthenticatorData();
        this.rpIdHashValidator.validate(authenticatorData.getRpIdHash(), serverProperty);
        this.validateUVUPFlags(authenticatorData, registrationParameters.isUserVerificationRequired(), registrationParameters.isUserPresenceRequired());
        AuthenticationExtensionsAuthenticatorOutputs<RegistrationExtensionAuthenticatorOutput> authenticationExtensionsAuthenticatorOutputs = authenticatorData.getExtensions();
        this.authenticatorExtensionValidator.validate(authenticationExtensionsAuthenticatorOutputs);
        this.attestationValidator.validate(registrationObject);
        for (CustomCoreRegistrationValidator customRegistrationValidator : this.customRegistrationValidators) {
            customRegistrationValidator.validate(registrationObject);
        }
    }

    protected CoreRegistrationObject createCoreRegistrationObject(CoreRegistrationData registrationData, CoreRegistrationParameters registrationParameters) {
        return new CoreRegistrationObject(registrationData.getAttestationObject(), registrationData.getAttestationObjectBytes(), registrationData.getClientDataHash(), registrationParameters.getServerProperty());
    }

    void validateAuthenticatorDataField(AuthenticatorData<RegistrationExtensionAuthenticatorOutput> authenticatorData) {
        if (authenticatorData.getAttestedCredentialData() == null) {
            throw new ConstraintViolationException("attestedCredentialData must not be null on registration");
        }
    }

    void validateUVUPFlags(AuthenticatorData<RegistrationExtensionAuthenticatorOutput> authenticatorData, boolean isUserVerificationRequired, boolean isUserPresenceRequired) {
        if (isUserVerificationRequired && !authenticatorData.isFlagUV()) {
            throw new UserNotVerifiedException("Validator is configured to check user verified, but UV flag in authenticatorData is not set.");
        }
        if (isUserPresenceRequired && !authenticatorData.isFlagUP()) {
            throw new UserNotPresentException("Validator is configured to check user present, but UP flag in authenticatorData is not set.");
        }
    }

    public List<CustomCoreRegistrationValidator> getCustomRegistrationValidators() {
        return this.customRegistrationValidators;
    }
}

