/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.extension.client;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.webauthn4j.converter.jackson.deserializer.CredentialProtectionPolicyStringDeserializer;
import com.webauthn4j.converter.jackson.serializer.CredentialProtectionPolicyStringSerializer;
import com.webauthn4j.data.extension.CredentialProtectionPolicy;
import com.webauthn4j.data.extension.ExtensionInput;
import com.webauthn4j.data.extension.client.AuthenticationExtensionClientInput;
import com.webauthn4j.data.extension.client.CredentialPropertiesExtensionClientInput;
import com.webauthn4j.data.extension.client.CredentialProtectionExtensionClientInput;
import com.webauthn4j.data.extension.client.ExtensionClientInput;
import com.webauthn4j.data.extension.client.FIDOAppIDExclusionExtensionClientInput;
import com.webauthn4j.data.extension.client.FIDOAppIDExtensionClientInput;
import com.webauthn4j.data.extension.client.RegistrationExtensionClientInput;
import com.webauthn4j.data.extension.client.UserVerificationMethodExtensionClientInput;
import com.webauthn4j.util.AssertUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class AuthenticationExtensionsClientInputs<T extends ExtensionClientInput>
implements Serializable {
    @JsonProperty
    private String appid;
    @JsonProperty
    private String appidExclude;
    @JsonProperty
    private Boolean uvm;
    @JsonProperty
    private Boolean credProps;
    @JsonSerialize(using=CredentialProtectionPolicyStringSerializer.class)
    @JsonDeserialize(using=CredentialProtectionPolicyStringDeserializer.class)
    @JsonProperty
    private CredentialProtectionPolicy credentialProtectionPolicy;
    @JsonProperty
    private Boolean enforceCredentialProtectionPolicy;
    @JsonIgnore
    private Map<String, Serializable> unknowns = new HashMap<String, Serializable>();
    @JsonIgnore
    private Map<Class<? extends T>, T> extensions;

    @JsonAnyGetter
    private Map<String, Serializable> getUnknowns() {
        return Collections.unmodifiableMap(this.unknowns);
    }

    @JsonAnySetter
    private void setUnknowns(String name, Serializable value) {
        this.unknowns.put(name, value);
    }

    @JsonIgnore
    public Set<String> getKeys() {
        HashSet<String> keys = new HashSet<String>();
        if (this.appid != null) {
            keys.add("appid");
        }
        if (this.appidExclude != null) {
            keys.add("appidExclude");
        }
        if (this.uvm != null) {
            keys.add("uvm");
        }
        if (this.credProps != null) {
            keys.add("credProps");
        }
        if (this.credentialProtectionPolicy != null) {
            keys.add("credentialProtectionPolicy");
        }
        if (this.enforceCredentialProtectionPolicy != null) {
            keys.add("enforceCredentialProtectionPolicy");
        }
        keys.addAll(this.getUnknownKeys());
        return keys;
    }

    @JsonIgnore
    public Set<String> getUnknownKeys() {
        return this.unknowns.keySet();
    }

    @JsonIgnore
    public Serializable getValue(String key) {
        switch (key) {
            case "appid": {
                return this.appid;
            }
            case "appidExclude": {
                return this.appidExclude;
            }
            case "uvm": {
                return this.uvm;
            }
            case "credProps": {
                return this.credProps;
            }
            case "credentialProtectionPolicy": {
                return this.credentialProtectionPolicy;
            }
            case "enforceCredentialProtectionPolicy": {
                return this.enforceCredentialProtectionPolicy;
            }
        }
        return this.unknowns.get(key);
    }

    @JsonIgnore
    public String getAppid() {
        return this.appid;
    }

    @JsonIgnore
    public String getAppidExclude() {
        return this.appidExclude;
    }

    @JsonIgnore
    public Boolean getUvm() {
        return this.uvm;
    }

    @JsonIgnore
    public Boolean getCredProps() {
        return this.credProps;
    }

    @JsonIgnore
    public CredentialProtectionPolicy getCredentialProtectionPolicy() {
        return this.credentialProtectionPolicy;
    }

    @JsonIgnore
    public Boolean getEnforceCredentialProtectionPolicy() {
        return this.enforceCredentialProtectionPolicy;
    }

    public <E extends T> E getExtension(Class<E> tClass) {
        return (E)((ExtensionClientInput)this.getExtensions().get(tClass));
    }

    @JsonIgnore
    public Map<Class<? extends T>, T> getExtensions() {
        if (this.extensions == null) {
            HashMap<Class<CredentialProtectionExtensionClientInput>, ExtensionInput> map = new HashMap<Class<CredentialProtectionExtensionClientInput>, ExtensionInput>();
            if (this.appid != null) {
                map.put(FIDOAppIDExtensionClientInput.class, new FIDOAppIDExtensionClientInput(this.appid));
            }
            if (this.appidExclude != null) {
                map.put(FIDOAppIDExclusionExtensionClientInput.class, new FIDOAppIDExclusionExtensionClientInput(this.appidExclude));
            }
            if (this.uvm != null) {
                map.put(UserVerificationMethodExtensionClientInput.class, new UserVerificationMethodExtensionClientInput(this.uvm));
            }
            if (this.credProps != null) {
                map.put(CredentialPropertiesExtensionClientInput.class, new CredentialPropertiesExtensionClientInput(this.credProps));
            }
            if (this.credentialProtectionPolicy != null) {
                map.put(CredentialProtectionExtensionClientInput.class, new CredentialProtectionExtensionClientInput(this.credentialProtectionPolicy, this.enforceCredentialProtectionPolicy));
            }
            this.extensions = Collections.unmodifiableMap(map);
        }
        return this.extensions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationExtensionsClientInputs that = (AuthenticationExtensionsClientInputs)o;
        return Objects.equals(this.appid, that.appid) && Objects.equals(this.appidExclude, that.appidExclude) && Objects.equals(this.uvm, that.uvm) && Objects.equals(this.credProps, that.credProps) && Objects.equals((Object)this.credentialProtectionPolicy, (Object)that.credentialProtectionPolicy) && Objects.equals(this.enforceCredentialProtectionPolicy, that.enforceCredentialProtectionPolicy) && Objects.equals(this.unknowns, that.unknowns) && Objects.equals(this.extensions, that.extensions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.appid, this.appidExclude, this.uvm, this.credProps, this.credentialProtectionPolicy, this.enforceCredentialProtectionPolicy, this.unknowns, this.extensions});
    }

    public static class BuilderForAuthentication {
        private String appid;
        private String appidExclude;
        private Boolean uvm;
        private Map<String, Serializable> unknowns = new HashMap<String, Serializable>();

        public AuthenticationExtensionsClientInputs<AuthenticationExtensionClientInput> build() {
            AuthenticationExtensionsClientInputs<AuthenticationExtensionClientInput> instance = new AuthenticationExtensionsClientInputs<AuthenticationExtensionClientInput>();
            ((AuthenticationExtensionsClientInputs)instance).appid = this.appid;
            ((AuthenticationExtensionsClientInputs)instance).appidExclude = this.appidExclude;
            ((AuthenticationExtensionsClientInputs)instance).uvm = this.uvm;
            ((AuthenticationExtensionsClientInputs)instance).unknowns.putAll(this.unknowns);
            return instance;
        }

        public BuilderForAuthentication setAppid(String appid) {
            this.appid = appid;
            return this;
        }

        public BuilderForAuthentication setAppidExclude(String appidExclude) {
            this.appidExclude = appidExclude;
            return this;
        }

        public BuilderForAuthentication setUvm(Boolean uvm) {
            this.uvm = uvm;
            return this;
        }

        public BuilderForAuthentication set(String key, Serializable value) {
            AssertUtil.notNull((Object)key, (String)"key must not be null.");
            AssertUtil.notNull((Object)value, (String)"value must not be null.");
            this.unknowns.put(key, value);
            return this;
        }
    }

    public static class BuilderForRegistration {
        private Boolean uvm;
        private Boolean credProps;
        private CredentialProtectionPolicy credentialProtectionPolicy;
        private Boolean enforceCredentialProtectionPolicy;
        private Map<String, Serializable> unknowns = new HashMap<String, Serializable>();

        public AuthenticationExtensionsClientInputs<RegistrationExtensionClientInput> build() {
            AuthenticationExtensionsClientInputs<RegistrationExtensionClientInput> instance = new AuthenticationExtensionsClientInputs<RegistrationExtensionClientInput>();
            ((AuthenticationExtensionsClientInputs)instance).uvm = this.uvm;
            ((AuthenticationExtensionsClientInputs)instance).credProps = this.credProps;
            ((AuthenticationExtensionsClientInputs)instance).credentialProtectionPolicy = this.credentialProtectionPolicy;
            ((AuthenticationExtensionsClientInputs)instance).enforceCredentialProtectionPolicy = this.enforceCredentialProtectionPolicy;
            ((AuthenticationExtensionsClientInputs)instance).unknowns.putAll(this.unknowns);
            return instance;
        }

        public BuilderForRegistration setUvm(Boolean uvm) {
            this.uvm = uvm;
            return this;
        }

        public BuilderForRegistration setCredProps(Boolean credProps) {
            this.credProps = credProps;
            return this;
        }

        public BuilderForRegistration setCredentialProtectionPolicy(CredentialProtectionPolicy credentialProtectionPolicy) {
            this.credentialProtectionPolicy = credentialProtectionPolicy;
            return this;
        }

        public BuilderForRegistration setEnforceCredentialProtectionPolicy(Boolean enforceCredentialProtectionPolicy) {
            this.enforceCredentialProtectionPolicy = enforceCredentialProtectionPolicy;
            return this;
        }

        public BuilderForRegistration set(String key, Serializable value) {
            AssertUtil.notNull((Object)key, (String)"key must not be null.");
            AssertUtil.notNull((Object)value, (String)"value must not be null.");
            this.unknowns.put(key, value);
            return this;
        }
    }
}

