/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.extension.authenticator;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.webauthn4j.converter.jackson.deserializer.CredentialProtectionPolicyByteDeserializer;
import com.webauthn4j.converter.jackson.serializer.CredentialProtectionPolicyByteSerializer;
import com.webauthn4j.data.extension.CredentialProtectionPolicy;
import com.webauthn4j.data.extension.UvmEntries;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.authenticator.CredentialProtectionExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.authenticator.ExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.authenticator.RegistrationExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.authenticator.UserVerificationMethodExtensionAuthenticatorOutput;
import com.webauthn4j.util.AssertUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class AuthenticationExtensionsAuthenticatorOutputs<T extends ExtensionAuthenticatorOutput>
implements Serializable {
    @JsonProperty
    private UvmEntries uvm;
    @JsonSerialize(using=CredentialProtectionPolicyByteSerializer.class)
    @JsonDeserialize(using=CredentialProtectionPolicyByteDeserializer.class)
    @JsonProperty
    private CredentialProtectionPolicy credProtect;
    @JsonIgnore
    private Map<String, Serializable> unknowns = new HashMap<String, Serializable>();
    @JsonIgnore
    private Map<Class<? extends T>, T> extensions;

    @JsonAnySetter
    private void setUnknowns(String name, Serializable value) {
        this.unknowns.put(name, value);
    }

    @JsonAnyGetter
    private Map<String, Serializable> getUnknowns() {
        return this.unknowns;
    }

    @JsonIgnore
    public Set<String> getKeys() {
        HashSet<String> keys = new HashSet<String>();
        if (this.uvm != null) {
            keys.add("uvm");
        }
        if (this.credProtect != null) {
            keys.add("credProtect");
        }
        keys.addAll(this.getUnknownKeys());
        return keys;
    }

    @JsonIgnore
    public Set<String> getUnknownKeys() {
        return this.unknowns.keySet();
    }

    @JsonIgnore
    public Object getValue(String key) {
        switch (key) {
            case "uvm": {
                return this.uvm;
            }
            case "credProtect": {
                return this.credProtect;
            }
        }
        return this.unknowns.get(key);
    }

    @JsonIgnore
    public UvmEntries getUvm() {
        return this.uvm;
    }

    @JsonIgnore
    public CredentialProtectionPolicy getCredProtect() {
        return this.credProtect;
    }

    public <E extends T> E getExtension(Class<E> tClass) {
        return (E)((ExtensionAuthenticatorOutput)this.getExtensions().get(tClass));
    }

    @JsonIgnore
    public Map<Class<? extends T>, T> getExtensions() {
        if (this.extensions == null) {
            HashMap<Class, RegistrationExtensionAuthenticatorOutput> map = new HashMap<Class, RegistrationExtensionAuthenticatorOutput>();
            if (this.uvm != null) {
                map.put(UserVerificationMethodExtensionAuthenticatorOutput.class, new UserVerificationMethodExtensionAuthenticatorOutput(this.uvm));
            }
            if (this.credProtect != null) {
                map.put(CredentialProtectionExtensionAuthenticatorOutput.class, new CredentialProtectionExtensionAuthenticatorOutput(this.credProtect));
            }
            this.extensions = Collections.unmodifiableMap(map);
        }
        return this.extensions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationExtensionsAuthenticatorOutputs that = (AuthenticationExtensionsAuthenticatorOutputs)o;
        return Objects.equals(this.uvm, that.uvm) && Objects.equals((Object)this.credProtect, (Object)that.credProtect) && Objects.equals(this.unknowns, that.unknowns) && Objects.equals(this.extensions, that.extensions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.uvm, this.credProtect, this.unknowns, this.extensions});
    }

    public static class BuilderForAuthentication {
        private UvmEntries uvm;
        private Map<String, Serializable> unknowns = new HashMap<String, Serializable>();

        public AuthenticationExtensionsAuthenticatorOutputs<AuthenticationExtensionAuthenticatorOutput> build() {
            AuthenticationExtensionsAuthenticatorOutputs<AuthenticationExtensionAuthenticatorOutput> instance = new AuthenticationExtensionsAuthenticatorOutputs<AuthenticationExtensionAuthenticatorOutput>();
            ((AuthenticationExtensionsAuthenticatorOutputs)instance).uvm = this.uvm;
            ((AuthenticationExtensionsAuthenticatorOutputs)instance).unknowns.putAll(this.unknowns);
            return instance;
        }

        public BuilderForAuthentication setUvm(UvmEntries uvm) {
            this.uvm = uvm;
            return this;
        }

        public BuilderForAuthentication set(String key, Serializable value) {
            AssertUtil.notNull((Object)key, (String)"key must not be null.");
            AssertUtil.notNull((Object)value, (String)"value must not be null.");
            this.unknowns.put(key, value);
            return this;
        }
    }

    public static class BuilderForRegistration {
        private UvmEntries uvm;
        private CredentialProtectionPolicy credProtect;
        private Map<String, Serializable> unknowns = new HashMap<String, Serializable>();

        public AuthenticationExtensionsAuthenticatorOutputs<RegistrationExtensionAuthenticatorOutput> build() {
            AuthenticationExtensionsAuthenticatorOutputs<RegistrationExtensionAuthenticatorOutput> instance = new AuthenticationExtensionsAuthenticatorOutputs<RegistrationExtensionAuthenticatorOutput>();
            ((AuthenticationExtensionsAuthenticatorOutputs)instance).uvm = this.uvm;
            ((AuthenticationExtensionsAuthenticatorOutputs)instance).credProtect = this.credProtect;
            ((AuthenticationExtensionsAuthenticatorOutputs)instance).unknowns.putAll(this.unknowns);
            return instance;
        }

        public BuilderForRegistration setUvm(UvmEntries uvm) {
            this.uvm = uvm;
            return this;
        }

        public BuilderForRegistration setCredProtect(CredentialProtectionPolicy credProtect) {
            this.credProtect = credProtect;
            return this;
        }

        public BuilderForRegistration set(String key, Serializable value) {
            AssertUtil.notNull((Object)key, (String)"key must not be null.");
            AssertUtil.notNull((Object)value, (String)"value must not be null.");
            this.unknowns.put(key, value);
            return this;
        }
    }
}

