/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator;

import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.data.attestation.statement.AttestationStatement;
import com.webauthn4j.data.attestation.statement.AttestationType;
import com.webauthn4j.data.attestation.statement.CertificateBaseAttestationStatement;
import com.webauthn4j.validator.RegistrationObject;
import com.webauthn4j.validator.attestation.statement.AttestationStatementValidator;
import com.webauthn4j.validator.attestation.trustworthiness.certpath.CertPathTrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.self.SelfAttestationTrustworthinessValidator;
import com.webauthn4j.validator.exception.BadAaguidException;
import com.webauthn4j.validator.exception.BadAttestationStatementException;
import java.util.List;
import java.util.Objects;

class AttestationValidator {
    private static final AAGUID U2F_AAGUID = AAGUID.ZERO;
    private final List<AttestationStatementValidator> attestationStatementValidators;
    private final CertPathTrustworthinessValidator certPathTrustworthinessValidator;
    private final SelfAttestationTrustworthinessValidator selfAttestationTrustworthinessValidator;

    AttestationValidator(List<AttestationStatementValidator> attestationStatementValidators, CertPathTrustworthinessValidator certPathTrustworthinessValidator, SelfAttestationTrustworthinessValidator selfAttestationTrustworthinessValidator) {
        this.attestationStatementValidators = attestationStatementValidators;
        this.certPathTrustworthinessValidator = certPathTrustworthinessValidator;
        this.selfAttestationTrustworthinessValidator = selfAttestationTrustworthinessValidator;
    }

    public void validate(RegistrationObject registrationObject) {
        AttestationObject attestationObject = registrationObject.getAttestationObject();
        AttestationType attestationType = this.validateAttestationStatement(registrationObject);
        this.validateAAGUID(attestationObject);
        AttestationStatement attestationStatement = attestationObject.getAttestationStatement();
        switch (attestationType) {
            case SELF: {
                if (attestationStatement instanceof CertificateBaseAttestationStatement) {
                    CertificateBaseAttestationStatement certificateBaseAttestationStatement = (CertificateBaseAttestationStatement)attestationStatement;
                    this.selfAttestationTrustworthinessValidator.validate(certificateBaseAttestationStatement);
                    break;
                }
                throw new IllegalStateException();
            }
            case BASIC: 
            case ATT_CA: {
                if (attestationStatement instanceof CertificateBaseAttestationStatement) {
                    CertificateBaseAttestationStatement certificateBaseAttestationStatement = (CertificateBaseAttestationStatement)attestationStatement;
                    AAGUID aaguid = attestationObject.getAuthenticatorData().getAttestedCredentialData().getAaguid();
                    this.certPathTrustworthinessValidator.validate(aaguid, certificateBaseAttestationStatement);
                    break;
                }
                throw new IllegalStateException();
            }
            case NONE: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    void validateAAGUID(AttestationObject attestationObject) {
        AAGUID aaguid;
        if (attestationObject.getFormat().equals("fido-u2f") && !Objects.equals(aaguid = attestationObject.getAuthenticatorData().getAttestedCredentialData().getAaguid(), U2F_AAGUID)) {
            throw new BadAaguidException("AAGUID is expected to be zero filled in U2F attestation, but it isn't.");
        }
    }

    private AttestationType validateAttestationStatement(RegistrationObject registrationObject) {
        for (AttestationStatementValidator validator : this.attestationStatementValidators) {
            if (!validator.supports(registrationObject)) continue;
            return validator.validate(registrationObject);
        }
        throw new BadAttestationStatementException(String.format("AttestationValidator is not configured to handle the supplied AttestationStatement format '%s'.", registrationObject.getAttestationObject().getFormat()));
    }
}

