/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.extension;

import java.io.Serializable;
import java.util.Objects;

public abstract class SingleValueExtensionBase<T extends Serializable> {
    private final T value;

    public SingleValueExtensionBase(T value) {
        this.value = value;
    }

    public SingleValueExtensionBase() {
        this.value = null;
    }

    public T getValue(String key) {
        if (!key.equals(this.getIdentifier())) {
            throw new IllegalArgumentException(String.format("%s is the only valid key.", this.getIdentifier()));
        }
        return this.value;
    }

    protected abstract String getIdentifier();

    public T getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleValueExtensionBase that = (SingleValueExtensionBase)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

