/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.webauthn4j.converter.jackson.deserializer.ChallengeDeserializer;
import com.webauthn4j.converter.jackson.deserializer.JWSDeserializer;
import com.webauthn4j.converter.jackson.deserializer.X509CertificateDeserializer;
import com.webauthn4j.converter.jackson.serializer.ChallengeSerializer;
import com.webauthn4j.converter.jackson.serializer.JWSSerializer;
import com.webauthn4j.converter.jackson.serializer.X509CertificateSerializer;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.client.challenge.Challenge;
import com.webauthn4j.data.jws.JWS;
import java.security.cert.X509Certificate;

public class WebAuthnJSONModule
extends SimpleModule {
    public WebAuthnJSONModule(ObjectConverter objectConverter) {
        super("WebAuthnJSONModule");
        this.addDeserializer(Challenge.class, (JsonDeserializer)new ChallengeDeserializer());
        this.addDeserializer(JWS.class, (JsonDeserializer)new JWSDeserializer(objectConverter));
        this.addDeserializer(X509Certificate.class, (JsonDeserializer)new X509CertificateDeserializer());
        this.addSerializer((JsonSerializer)new ChallengeSerializer());
        this.addSerializer((JsonSerializer)new JWSSerializer());
        this.addSerializer((JsonSerializer)new X509CertificateSerializer());
    }
}

