/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.util;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.webauthn4j.converter.exception.DataConversionException;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionsAuthenticatorOutputs;
import com.webauthn4j.util.AssertUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;

public class CborConverter
implements Serializable {
    private static final String INPUT_MISMATCH_ERROR_MESSAGE = "Input data does not match expected form";
    private ObjectMapper cborMapper;

    CborConverter(ObjectMapper cborMapper) {
        AssertUtil.notNull((Object)cborMapper, (String)"cborMapper must not be null");
        AssertUtil.isTrue((boolean)(cborMapper.getFactory() instanceof CBORFactory), (String)"factory of cborMapper must be CBORFactory.");
        this.cborMapper = cborMapper;
    }

    public <T> T readValue(byte[] src, Class valueType) {
        try {
            return (T)this.cborMapper.readValue(src, valueType);
        }
        catch (JsonParseException | MismatchedInputException e) {
            throw new DataConversionException(INPUT_MISMATCH_ERROR_MESSAGE, e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public <T> T readValue(InputStream src, Class valueType) {
        try {
            return (T)this.cborMapper.readValue(src, valueType);
        }
        catch (JsonParseException | MismatchedInputException e) {
            throw new DataConversionException(INPUT_MISMATCH_ERROR_MESSAGE, e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public <T> T readValue(byte[] src, TypeReference<T> valueTypeRef) {
        try {
            return (T)this.cborMapper.readValue(src, valueTypeRef);
        }
        catch (JsonParseException | MismatchedInputException e) {
            throw new DataConversionException(INPUT_MISMATCH_ERROR_MESSAGE, e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public AuthenticationExtensionsAuthenticatorOutputs readValue(InputStream inputStream, TypeReference<AuthenticationExtensionsAuthenticatorOutputs> typeReference) {
        try {
            return (AuthenticationExtensionsAuthenticatorOutputs)this.cborMapper.readValue(inputStream, typeReference);
        }
        catch (JsonParseException | MismatchedInputException e) {
            throw new DataConversionException(INPUT_MISMATCH_ERROR_MESSAGE, e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public JsonNode readTree(byte[] bytes) {
        try {
            return this.cborMapper.readTree(bytes);
        }
        catch (JsonParseException | MismatchedInputException e) {
            throw new DataConversionException(INPUT_MISMATCH_ERROR_MESSAGE, e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public byte[] writeValueAsBytes(Object value) {
        try {
            return this.cborMapper.writeValueAsBytes(value);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }
}

