/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.jws;

import com.webauthn4j.converter.util.JsonConverter;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.jws.JWS;
import com.webauthn4j.data.jws.JWSHeader;
import com.webauthn4j.data.jws.JWSSignatureUtil;
import com.webauthn4j.util.Base64UrlUtil;
import com.webauthn4j.util.SignatureUtil;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;

public class JWSFactory {
    private JsonConverter jsonConverter;

    public JWSFactory(ObjectConverter objectConverter) {
        this.jsonConverter = objectConverter.getJsonConverter();
    }

    @Deprecated
    public JWSFactory(JsonConverter jsonConverter) {
        this.jsonConverter = jsonConverter;
    }

    public JWSFactory() {
        this(new ObjectConverter());
    }

    public <T extends Serializable> JWS<T> create(JWSHeader header, T payload, PrivateKey privateKey) {
        String headerString = Base64UrlUtil.encodeToString((byte[])this.jsonConverter.writeValueAsString(header).getBytes(StandardCharsets.UTF_8));
        String payloadString = Base64UrlUtil.encodeToString((byte[])this.jsonConverter.writeValueAsString(payload).getBytes(StandardCharsets.UTF_8));
        String signedData = headerString + "." + payloadString;
        Signature signatureObj = SignatureUtil.createSignature((String)header.getAlg().getJcaName());
        try {
            signatureObj.initSign(privateKey);
            signatureObj.update(signedData.getBytes());
            byte[] derSignature = signatureObj.sign();
            byte[] jwsSignature = JWSSignatureUtil.convertDerSignatureToJwsSignature(derSignature);
            return new JWS<T>(header, headerString, payload, payloadString, jwsSignature);
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public <T extends Serializable> JWS<T> create(JWSHeader header, T payload, byte[] signature) {
        String headerString = Base64UrlUtil.encodeToString((byte[])this.jsonConverter.writeValueAsString(header).getBytes(StandardCharsets.UTF_8));
        String payloadString = Base64UrlUtil.encodeToString((byte[])this.jsonConverter.writeValueAsString(payload).getBytes(StandardCharsets.UTF_8));
        return new JWS<T>(header, headerString, payload, payloadString, signature);
    }

    public <T extends Serializable> JWS<T> parse(String value, Class<T> payloadType) {
        String[] data = value.split("\\.");
        if (data.length != 3) {
            throw new IllegalArgumentException("JWS value is not divided by two period.");
        }
        String headerString = data[0];
        String payloadString = data[1];
        String signatureString = data[2];
        JWSHeader header = (JWSHeader)this.jsonConverter.readValue(new String(Base64UrlUtil.decode((String)headerString)), JWSHeader.class);
        Serializable payload = (Serializable)this.jsonConverter.readValue(new String(Base64UrlUtil.decode((String)payloadString)), payloadType);
        byte[] signature = Base64UrlUtil.decode((String)signatureString);
        return new JWS<Serializable>(header, headerString, payload, payloadString, signature);
    }
}

