/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.dataformat.cbor.CBORGenerator;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

abstract class AbstractCtapCanonicalCborSerializer<T>
extends StdSerializer<T> {
    private transient List<FieldSerializationRule<T, ?>> rules;

    AbstractCtapCanonicalCborSerializer(Class<T> t, List<FieldSerializationRule<T, ?>> rules) {
        super(t);
        this.rules = rules;
    }

    public void serialize(T value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        List nonNullValues = this.rules.stream().map(rule -> {
            Object fieldValue = rule.getGetter().apply(value);
            return new KeyValue(rule.getName(), fieldValue);
        }).filter(item -> ((KeyValue)item).value != null).collect(Collectors.toList());
        ((CBORGenerator)gen).writeStartObject(nonNullValues.size());
        for (KeyValue nonNullValue : nonNullValues) {
            if (nonNullValue.name instanceof String) {
                gen.writeFieldName((String)nonNullValue.name);
            } else {
                gen.writeFieldId((long)((Integer)nonNullValue.name).intValue());
            }
            gen.writeObject(nonNullValue.value);
        }
        gen.writeEndObject();
    }

    static class FieldSerializationRule<T, R> {
        private Object name;
        private Function<T, R> getter;

        public FieldSerializationRule(int name, Function<T, R> getter) {
            this.name = name;
            this.getter = getter;
        }

        public FieldSerializationRule(String name, Function<T, R> getter) {
            this.name = name;
            this.getter = getter;
        }

        public Object getName() {
            return this.name;
        }

        public Function<T, R> getGetter() {
            return this.getter;
        }
    }

    private static class KeyValue {
        private Object name;
        private Object value;

        public KeyValue(Object name, Object value) {
            this.name = name;
            this.value = value;
        }
    }
}

