/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.async.verifier.attestation.trustworthiness.self;

import com.webauthn4j.async.verifier.attestation.trustworthiness.self.SelfAttestationTrustworthinessAsyncVerifier;
import com.webauthn4j.data.attestation.statement.CertificateBaseAttestationStatement;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.CompletionStageUtil;
import com.webauthn4j.verifier.exception.BadAttestationStatementException;
import com.webauthn4j.verifier.exception.SelfAttestationProhibitedException;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;

public class DefaultSelfAttestationTrustworthinessAsyncVerifier
implements SelfAttestationTrustworthinessAsyncVerifier {
    private boolean isSelfAttestationAllowed = true;

    @Override
    public CompletionStage<Void> verify(@NotNull CertificateBaseAttestationStatement attestationStatement) {
        return CompletionStageUtil.supply(() -> {
            AssertUtil.notNull((Object)attestationStatement, (String)"attestationStatement must not be null");
            if (!this.isSelfAttestationAllowed()) {
                throw new SelfAttestationProhibitedException("SELF attestations is prohibited by configuration");
            }
            if (attestationStatement.getX5c() != null) {
                throw new BadAttestationStatementException("SELF attestation must not have x5c.");
            }
            return null;
        });
    }

    public boolean isSelfAttestationAllowed() {
        return this.isSelfAttestationAllowed;
    }

    public void setSelfAttestationAllowed(boolean selfAttestationAllowed) {
        this.isSelfAttestationAllowed = selfAttestationAllowed;
    }
}

