/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.appattest.verifier;

import com.webauthn4j.appattest.data.DCAttestationData;
import com.webauthn4j.appattest.verifier.DCRegistrationObject;
import com.webauthn4j.appattest.verifier.attestation.statement.appleappattest.AppleAppAttestAttestationStatementVerifier;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.CoreRegistrationData;
import com.webauthn4j.data.CoreRegistrationParameters;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.extension.authenticator.RegistrationExtensionAuthenticatorOutput;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.verifier.CoreRegistrationDataVerifier;
import com.webauthn4j.verifier.CoreRegistrationObject;
import com.webauthn4j.verifier.CustomCoreRegistrationVerifier;
import com.webauthn4j.verifier.attestation.trustworthiness.certpath.CertPathTrustworthinessVerifier;
import com.webauthn4j.verifier.attestation.trustworthiness.self.DefaultSelfAttestationTrustworthinessVerifier;
import com.webauthn4j.verifier.attestation.trustworthiness.self.SelfAttestationTrustworthinessVerifier;
import com.webauthn4j.verifier.exception.BadAaguidException;
import com.webauthn4j.verifier.exception.BadAttestationStatementException;
import com.webauthn4j.verifier.exception.MaliciousCounterValueException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DCAttestationDataVerifier
extends CoreRegistrationDataVerifier {
    private static final AAGUID APPLE_APP_ATTEST_ENVIRONMENT_DEVELOPMENT = new AAGUID("appattestdevelop".getBytes());
    private static final AAGUID APPLE_APP_ATTEST_ENVIRONMENT_PRODUCTION = new AAGUID("appattest\u0000\u0000\u0000\u0000\u0000\u0000\u0000".getBytes());
    private boolean production = true;

    public DCAttestationDataVerifier(@NotNull CertPathTrustworthinessVerifier certPathTrustworthinessVerifier, @NotNull List<CustomCoreRegistrationVerifier> customRegistrationValidatorList, @NotNull ObjectConverter objectConverter) {
        super(Collections.singletonList(new AppleAppAttestAttestationStatementVerifier()), certPathTrustworthinessVerifier, DCAttestationDataVerifier.createSelfAttestationTrustWorthinessValidator(), customRegistrationValidatorList, objectConverter);
    }

    @NotNull
    private static SelfAttestationTrustworthinessVerifier createSelfAttestationTrustWorthinessValidator() {
        DefaultSelfAttestationTrustworthinessVerifier selfAttestationTrustworthinessValidator = new DefaultSelfAttestationTrustworthinessVerifier();
        selfAttestationTrustworthinessValidator.setSelfAttestationAllowed(false);
        return selfAttestationTrustworthinessValidator;
    }

    public void verify(@NotNull CoreRegistrationData registrationData, @NotNull CoreRegistrationParameters registrationParameters) {
        super.verify(registrationData, registrationParameters);
        this.validateAuthenticatorData((AuthenticatorData<RegistrationExtensionAuthenticatorOutput>)registrationData.getAttestationObject().getAuthenticatorData());
        this.validateKeyId(registrationData);
    }

    private void validateKeyId(@NotNull CoreRegistrationData registrationData) {
        byte[] credentialId;
        DCAttestationData dcAttestationData = (DCAttestationData)registrationData;
        byte[] keyId = dcAttestationData.getKeyId();
        if (!Arrays.equals(keyId, credentialId = registrationData.getAttestationObject().getAuthenticatorData().getAttestedCredentialData().getCredentialId())) {
            throw new BadAttestationStatementException("key identifier doesn't match credentialId.");
        }
    }

    @NotNull
    protected CoreRegistrationObject createCoreRegistrationObject(@NotNull CoreRegistrationData registrationData, @NotNull CoreRegistrationParameters registrationParameters) {
        AssertUtil.notNull((Object)registrationData, (String)"authenticationData must not be null");
        AssertUtil.notNull((Object)registrationData, (String)"authenticationParameters must not be null");
        DCAttestationData dcAttestationData = (DCAttestationData)registrationData;
        return new DCRegistrationObject(dcAttestationData.getKeyId(), registrationData.getAttestationObject(), registrationData.getAttestationObjectBytes(), registrationData.getClientDataHash(), registrationParameters.getServerProperty(), Instant.now());
    }

    public boolean isProduction() {
        return this.production;
    }

    public void setProduction(boolean production) {
        this.production = production;
    }

    private void validateAuthenticatorData(@NotNull AuthenticatorData<RegistrationExtensionAuthenticatorOutput> authenticatorData) {
        AAGUID expectedAAGUID;
        if (authenticatorData.getSignCount() != 0L) {
            throw new MaliciousCounterValueException("Counter is not zero");
        }
        AAGUID aaguid = authenticatorData.getAttestedCredentialData().getAaguid();
        AAGUID aAGUID = expectedAAGUID = this.isProduction() ? APPLE_APP_ATTEST_ENVIRONMENT_PRODUCTION : APPLE_APP_ATTEST_ENVIRONMENT_DEVELOPMENT;
        if (!aaguid.equals((Object)expectedAAGUID)) {
            throw new BadAaguidException("Expected AAGUID of either 'appattestdevelop' or 'appattest'");
        }
    }
}

