/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.appattest.data;

import com.webauthn4j.util.ArrayUtil;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public class DCAssertionRequest {
    private final byte[] keyId;
    private final byte[] assertion;
    private final byte[] clientDataHash;

    public DCAssertionRequest(@Nullable byte[] keyId, @Nullable byte[] assertion, @Nullable byte[] clientDataHash) {
        this.keyId = ArrayUtil.clone((byte[])keyId);
        this.assertion = ArrayUtil.clone((byte[])assertion);
        this.clientDataHash = ArrayUtil.clone((byte[])clientDataHash);
    }

    @Nullable
    public byte[] getKeyId() {
        return ArrayUtil.clone((byte[])this.keyId);
    }

    @Nullable
    public byte[] getAssertion() {
        return ArrayUtil.clone((byte[])this.assertion);
    }

    @Nullable
    public byte[] getClientDataHash() {
        return ArrayUtil.clone((byte[])this.clientDataHash);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DCAssertionRequest that = (DCAssertionRequest)o;
        return Arrays.equals(this.keyId, that.keyId) && Arrays.equals(this.assertion, that.assertion) && Arrays.equals(this.clientDataHash, that.clientDataHash);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.keyId);
        result = 31 * result + Arrays.hashCode(this.assertion);
        result = 31 * result + Arrays.hashCode(this.clientDataHash);
        return result;
    }
}

