/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.appattest;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.webauthn4j.appattest.DeviceCheckAssertionManager;
import com.webauthn4j.appattest.DeviceCheckAttestationManager;
import com.webauthn4j.appattest.converter.jackson.DeviceCheckCBORModule;
import com.webauthn4j.appattest.data.DCAssertionData;
import com.webauthn4j.appattest.data.DCAssertionParameters;
import com.webauthn4j.appattest.data.DCAssertionRequest;
import com.webauthn4j.appattest.data.DCAttestationData;
import com.webauthn4j.appattest.data.DCAttestationParameters;
import com.webauthn4j.appattest.data.DCAttestationRequest;
import com.webauthn4j.appattest.verifier.DCAssertionDataVerifier;
import com.webauthn4j.appattest.verifier.DCAttestationDataVerifier;
import com.webauthn4j.converter.exception.DataConversionException;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.verifier.CustomCoreAuthenticationVerifier;
import com.webauthn4j.verifier.CustomCoreRegistrationVerifier;
import com.webauthn4j.verifier.attestation.trustworthiness.certpath.CertPathTrustworthinessVerifier;
import com.webauthn4j.verifier.attestation.trustworthiness.certpath.NullCertPathTrustworthinessVerifier;
import com.webauthn4j.verifier.exception.VerificationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DeviceCheckManager {
    private final DeviceCheckAttestationManager deviceCheckAttestationManager;
    private final DeviceCheckAssertionManager deviceCheckAssertionManager;

    public DeviceCheckManager(@NotNull CertPathTrustworthinessVerifier certPathTrustworthinessVerifier, @NotNull List<CustomCoreRegistrationVerifier> customRegistrationValidators, @NotNull List<CustomCoreAuthenticationVerifier> customAuthenticationValidators, @NotNull ObjectConverter objectConverter) {
        this.deviceCheckAttestationManager = new DeviceCheckAttestationManager(certPathTrustworthinessVerifier, customRegistrationValidators, objectConverter);
        this.deviceCheckAssertionManager = new DeviceCheckAssertionManager(customAuthenticationValidators, objectConverter);
    }

    public DeviceCheckManager(@NotNull CertPathTrustworthinessVerifier certPathTrustworthinessVerifier, @NotNull List<CustomCoreRegistrationVerifier> customRegistrationValidators, @NotNull List<CustomCoreAuthenticationVerifier> customAuthenticationValidators) {
        this(certPathTrustworthinessVerifier, customRegistrationValidators, customAuthenticationValidators, DeviceCheckManager.createObjectConverter());
    }

    public DeviceCheckManager(@NotNull CertPathTrustworthinessVerifier certPathTrustworthinessVerifier, @NotNull ObjectConverter objectConverter) {
        this(certPathTrustworthinessVerifier, new ArrayList<CustomCoreRegistrationVerifier>(), new ArrayList<CustomCoreAuthenticationVerifier>(), objectConverter);
    }

    public DeviceCheckManager(@NotNull CertPathTrustworthinessVerifier certPathTrustworthinessVerifier) {
        this(certPathTrustworthinessVerifier, new ArrayList<CustomCoreRegistrationVerifier>(), new ArrayList<CustomCoreAuthenticationVerifier>());
    }

    @NotNull
    public static DeviceCheckManager createNonStrictDeviceCheckManager() {
        ObjectMapper jsonMapper = new ObjectMapper();
        ObjectMapper cborMapper = new ObjectMapper((JsonFactory)new CBORFactory());
        cborMapper.registerModule((Module)new DeviceCheckCBORModule());
        ObjectConverter objectConverter = new ObjectConverter(jsonMapper, cborMapper);
        return DeviceCheckManager.createNonStrictDeviceCheckManager(objectConverter);
    }

    @NotNull
    public static DeviceCheckManager createNonStrictDeviceCheckManager(@NotNull ObjectConverter objectConverter) {
        return new DeviceCheckManager((CertPathTrustworthinessVerifier)new NullCertPathTrustworthinessVerifier(), objectConverter);
    }

    @NotNull
    public static ObjectConverter createObjectConverter() {
        ObjectMapper jsonMapper = new ObjectMapper();
        ObjectMapper cborMapper = new ObjectMapper((JsonFactory)new CBORFactory());
        cborMapper.registerModule((Module)new DeviceCheckCBORModule());
        return new ObjectConverter(jsonMapper, cborMapper);
    }

    @NotNull
    public DCAttestationData parse(@NotNull DCAttestationRequest dcAttestationRequest) throws DataConversionException {
        return this.deviceCheckAttestationManager.parse(dcAttestationRequest);
    }

    @NotNull
    public DCAttestationData validate(@NotNull DCAttestationRequest dcAttestationRequest, @NotNull DCAttestationParameters dcAttestationParameters) throws DataConversionException, VerificationException {
        return this.deviceCheckAttestationManager.validate(dcAttestationRequest, dcAttestationParameters);
    }

    @NotNull
    public DCAttestationData validate(@NotNull DCAttestationData dcAttestationData, @NotNull DCAttestationParameters dcAttestationParameters) throws VerificationException {
        return this.deviceCheckAttestationManager.validate(dcAttestationData, dcAttestationParameters);
    }

    @NotNull
    public DCAssertionData parse(@NotNull DCAssertionRequest dcAssertionRequest) throws DataConversionException {
        return this.deviceCheckAssertionManager.parse(dcAssertionRequest);
    }

    @NotNull
    public DCAssertionData validate(@NotNull DCAssertionRequest dcAssertionRequest, @NotNull DCAssertionParameters dcAssertionParameters) throws DataConversionException, VerificationException {
        return this.deviceCheckAssertionManager.verify(dcAssertionRequest, dcAssertionParameters);
    }

    @NotNull
    public DCAssertionData validate(@NotNull DCAssertionData dcAssertionData, @NotNull DCAssertionParameters dcAssertionParameters) throws VerificationException {
        return this.deviceCheckAssertionManager.verify(dcAssertionData, dcAssertionParameters);
    }

    @NotNull
    public DCAttestationDataVerifier getAttestationDataValidator() {
        return this.deviceCheckAttestationManager.getDCAttestationDataValidator();
    }

    @NotNull
    public DCAssertionDataVerifier getAssertionDataValidator() {
        return this.deviceCheckAssertionManager.getDCAssertionDataValidator();
    }
}

