/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.appattest;

import com.webauthn4j.appattest.data.DCAttestationData;
import com.webauthn4j.appattest.data.DCAttestationParameters;
import com.webauthn4j.appattest.data.DCAttestationRequest;
import com.webauthn4j.appattest.verifier.DCAttestationDataVerifier;
import com.webauthn4j.converter.AttestationObjectConverter;
import com.webauthn4j.converter.exception.DataConversionException;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.verifier.CustomCoreRegistrationVerifier;
import com.webauthn4j.verifier.attestation.trustworthiness.certpath.CertPathTrustworthinessVerifier;
import com.webauthn4j.verifier.exception.VerificationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DeviceCheckAttestationManager {
    private final AttestationObjectConverter attestationObjectConverter;
    private final DCAttestationDataVerifier dcAttestationDataValidator;

    public DeviceCheckAttestationManager(@NotNull CertPathTrustworthinessVerifier certPathTrustworthinessVerifier, @NotNull List<CustomCoreRegistrationVerifier> customRegistrationValidators, @NotNull ObjectConverter objectConverter) {
        AssertUtil.notNull((Object)certPathTrustworthinessVerifier, (String)"certPathTrustworthinessValidator must not be null");
        AssertUtil.notNull((Object)objectConverter, (String)"objectConverter must not be null");
        this.dcAttestationDataValidator = new DCAttestationDataVerifier(certPathTrustworthinessVerifier, customRegistrationValidators, objectConverter);
        this.attestationObjectConverter = new AttestationObjectConverter(objectConverter);
    }

    @NotNull
    public DCAttestationData parse(@NotNull DCAttestationRequest dcAttestationRequest) throws DataConversionException {
        AssertUtil.notNull((Object)dcAttestationRequest, (String)"dcAttestationRequest must not be null");
        byte[] keyId = dcAttestationRequest.getKeyId();
        byte[] attestationObjectBytes = dcAttestationRequest.getAttestationObject();
        byte[] clientDataHash = dcAttestationRequest.getClientDataHash();
        AttestationObject attestationObject = attestationObjectBytes == null ? null : this.attestationObjectConverter.convert(attestationObjectBytes);
        return new DCAttestationData(keyId, attestationObject, attestationObjectBytes, clientDataHash);
    }

    @NotNull
    public DCAttestationData validate(@NotNull DCAttestationRequest dcAttestationRequest, @NotNull DCAttestationParameters dcAttestationParameters) throws DataConversionException, VerificationException {
        DCAttestationData dcAttestationData = this.parse(dcAttestationRequest);
        return this.validate(dcAttestationData, dcAttestationParameters);
    }

    @NotNull
    public DCAttestationData validate(@NotNull DCAttestationData dcAttestationData, @NotNull DCAttestationParameters dcAttestationParameters) throws VerificationException {
        this.getDCAttestationDataValidator().verify(dcAttestationData, dcAttestationParameters);
        return dcAttestationData;
    }

    @NotNull
    public DCAttestationDataVerifier getDCAttestationDataValidator() {
        return this.dcAttestationDataValidator;
    }
}

