/*
 * Decompiled with CFR 0.152.
 */
package com.wdullaer.materialdatetimepicker.date;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import com.wdullaer.materialdatetimepicker.GravitySnapHelper;
import com.wdullaer.materialdatetimepicker.Utils;
import com.wdullaer.materialdatetimepicker.date.DatePickerController;
import com.wdullaer.materialdatetimepicker.date.DatePickerDialog;
import com.wdullaer.materialdatetimepicker.date.MonthAdapter;
import com.wdullaer.materialdatetimepicker.date.MonthView;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

public abstract class DayPickerView
extends RecyclerView
implements DatePickerDialog.OnDateChangedListener {
    private static final String TAG = "MonthFragment";
    protected static final int SCROLL_HYST_WEEKS = 2;
    public static final int DAYS_PER_WEEK = 7;
    protected int mNumWeeks = 6;
    protected boolean mShowWeekNumber = false;
    protected int mDaysPerWeek = 7;
    private static SimpleDateFormat YEAR_FORMAT = new SimpleDateFormat("yyyy", Locale.getDefault());
    protected Context mContext;
    protected Handler mHandler;
    protected MonthAdapter.CalendarDay mSelectedDay;
    protected MonthAdapter mAdapter;
    protected MonthAdapter.CalendarDay mTempDay;
    protected int mFirstDayOfWeek;
    protected CharSequence mPrevMonthName;
    protected int mCurrentMonthDisplayed;
    protected long mPreviousScrollPosition;
    protected int mPreviousScrollState = 0;
    private DatePickerController mController;
    private LinearLayoutManager linearLayoutManager;

    public DayPickerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public DayPickerView(Context context, DatePickerController controller) {
        super(context);
        this.setController(controller);
        this.init(context);
    }

    public void setController(DatePickerController controller) {
        this.mController = controller;
        this.mController.registerOnDateChangedListener(this);
        this.mSelectedDay = new MonthAdapter.CalendarDay(this.mController.getTimeZone());
        this.mTempDay = new MonthAdapter.CalendarDay(this.mController.getTimeZone());
        YEAR_FORMAT = new SimpleDateFormat("yyyy", controller.getLocale());
        this.refreshAdapter();
        this.onDateChanged();
    }

    public void init(Context context) {
        int scrollOrientation = this.mController.getScrollOrientation() == DatePickerDialog.ScrollOrientation.VERTICAL ? 1 : 0;
        this.linearLayoutManager = new LinearLayoutManager(context, scrollOrientation, false);
        this.setLayoutManager((RecyclerView.LayoutManager)this.linearLayoutManager);
        this.mHandler = new Handler();
        this.setLayoutParams((ViewGroup.LayoutParams)new RecyclerView.LayoutParams(-1, -1));
        this.setVerticalScrollBarEnabled(false);
        this.setHorizontalScrollBarEnabled(false);
        this.mContext = context;
        this.setUpRecyclerView();
    }

    public void setScrollOrientation(int orientation) {
        this.linearLayoutManager.setOrientation(orientation);
    }

    protected void setUpRecyclerView() {
        this.setVerticalScrollBarEnabled(false);
        this.setFadingEdgeLength(0);
        int gravity = this.mController.getScrollOrientation() == DatePickerDialog.ScrollOrientation.VERTICAL ? 48 : 0x800003;
        GravitySnapHelper helper = new GravitySnapHelper(gravity);
        helper.attachToRecyclerView(this);
    }

    public void onChange() {
        this.refreshAdapter();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        MonthAdapter.CalendarDay focusedDay = this.findAccessibilityFocus();
        this.restoreAccessibilityFocus(focusedDay);
    }

    protected void refreshAdapter() {
        if (this.mAdapter == null) {
            this.mAdapter = this.createMonthAdapter(this.mController);
        } else {
            this.mAdapter.setSelectedDay(this.mSelectedDay);
        }
        this.setAdapter(this.mAdapter);
    }

    public abstract MonthAdapter createMonthAdapter(DatePickerController var1);

    public boolean goTo(MonthAdapter.CalendarDay day, boolean animate, boolean setSelected, boolean forceScroll) {
        int selectedPosition;
        View child;
        if (setSelected) {
            this.mSelectedDay.set(day);
        }
        this.mTempDay.set(day);
        int minMonth = this.mController.getStartDate().get(2);
        int position = (day.year - this.mController.getMinYear()) * 12 + day.month - minMonth;
        int i = 0;
        int top = 0;
        while ((child = this.getChildAt(i++)) != null) {
            top = child.getTop();
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("child at " + (i - 1) + " has top " + top));
            }
            if (top < 0) continue;
        }
        int n = selectedPosition = child != null ? this.getChildAdapterPosition(child) : 0;
        if (setSelected) {
            this.mAdapter.setSelectedDay(this.mSelectedDay);
        }
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)("GoTo position " + position));
        }
        if (position != selectedPosition || forceScroll) {
            this.setMonthDisplayed(this.mTempDay);
            this.mPreviousScrollState = 1;
            if (animate) {
                this.smoothScrollToPosition(position);
                return true;
            }
            this.postSetSelection(position);
        } else if (setSelected) {
            this.setMonthDisplayed(this.mSelectedDay);
        }
        return false;
    }

    public void postSetSelection(final int position) {
        this.clearFocus();
        this.post(new Runnable(){

            @Override
            public void run() {
                ((LinearLayoutManager)DayPickerView.this.getLayoutManager()).scrollToPositionWithOffset(position, 0);
            }
        });
    }

    protected void setMonthDisplayed(MonthAdapter.CalendarDay date) {
        this.mCurrentMonthDisplayed = date.month;
    }

    public int getMostVisiblePosition() {
        return this.getChildAdapterPosition(this.getMostVisibleMonth());
    }

    public MonthView getMostVisibleMonth() {
        View child;
        boolean verticalScroll = ((LinearLayoutManager)this.getLayoutManager()).getOrientation() == 1;
        int maxSize = verticalScroll ? this.getHeight() : this.getWidth();
        int maxDisplayedSize = 0;
        int i = 0;
        int size = 0;
        MonthView mostVisibleMonth = null;
        while (size < maxSize && (child = this.getChildAt(i)) != null) {
            size = verticalScroll ? child.getBottom() : this.getRight();
            int displayedSize = Math.min(size, maxSize) - Math.max(0, child.getTop());
            if (displayedSize > maxDisplayedSize) {
                mostVisibleMonth = (MonthView)child;
                maxDisplayedSize = displayedSize;
            }
            ++i;
        }
        return mostVisibleMonth;
    }

    @Override
    public void onDateChanged() {
        this.goTo(this.mController.getSelectedDay(), false, true, true);
    }

    private MonthAdapter.CalendarDay findAccessibilityFocus() {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            MonthAdapter.CalendarDay focus;
            View child = this.getChildAt(i);
            if (!(child instanceof MonthView) || (focus = ((MonthView)child).getAccessibilityFocus()) == null) continue;
            if (Build.VERSION.SDK_INT == 17) {
                ((MonthView)child).clearAccessibilityFocus();
            }
            return focus;
        }
        return null;
    }

    private boolean restoreAccessibilityFocus(MonthAdapter.CalendarDay day) {
        if (day == null) {
            return false;
        }
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (!(child instanceof MonthView) || !((MonthView)child).restoreAccessibilityFocus(day)) continue;
            return true;
        }
        return false;
    }

    public void onInitializeAccessibilityEvent(@NonNull AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setItemCount(-1);
    }

    private static String getMonthAndYearString(MonthAdapter.CalendarDay day, Locale locale) {
        Calendar cal = Calendar.getInstance();
        cal.set(day.year, day.month, day.day);
        String sbuf = "";
        sbuf = sbuf + cal.getDisplayName(2, 2, locale);
        sbuf = sbuf + " ";
        sbuf = sbuf + YEAR_FORMAT.format(cal.getTime());
        return sbuf;
    }

    public void onInitializeAccessibilityNodeInfo(@NonNull AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        if (Build.VERSION.SDK_INT >= 21) {
            info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_BACKWARD);
            info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_FORWARD);
        } else {
            info.addAction(4096);
            info.addAction(8192);
        }
    }

    @SuppressLint(value={"NewApi"})
    public boolean performAccessibilityAction(int action, Bundle arguments) {
        View firstVisibleView;
        if (action != 4096 && action != 8192) {
            return super.performAccessibilityAction(action, arguments);
        }
        int firstVisiblePosition = this.getFirstVisiblePosition();
        int minMonth = this.mController.getStartDate().get(2);
        int month = (firstVisiblePosition + minMonth) % 12;
        int year = (firstVisiblePosition + minMonth) / 12 + this.mController.getMinYear();
        MonthAdapter.CalendarDay day = new MonthAdapter.CalendarDay(year, month, 1, this.mController.getTimeZone());
        if (action == 4096) {
            ++day.month;
            if (day.month == 12) {
                day.month = 0;
                ++day.year;
            }
        } else if (action == 8192 && (firstVisibleView = this.getChildAt(0)) != null && firstVisibleView.getTop() >= -1) {
            --day.month;
            if (day.month == -1) {
                day.month = 11;
                --day.year;
            }
        }
        Utils.tryAccessibilityAnnounce((View)this, DayPickerView.getMonthAndYearString(day, this.mController.getLocale()));
        this.goTo(day, true, false, true);
        return true;
    }

    private int getFirstVisiblePosition() {
        return this.getChildAdapterPosition(this.getChildAt(0));
    }
}

