/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.common.clients.service.token;

import com.wavefront.sdk.common.Utils;
import com.wavefront.sdk.common.clients.service.token.CSPURLConnectionFactory;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class CSPServerTokenURLConnectionFactory
implements CSPURLConnectionFactory {
    private static final String OAUTH_PATH = "/csp/gateway/am/api/auth/authorize";
    private static final String TYPE = "CSP OAUTH";
    private final String cspBaseURL;
    private final String cspClientId;
    private final String cspClientSecret;
    private final String cspOrgId;
    private final byte[] postData;
    private int connectTimeoutMillis = 30000;
    private int readTimeoutMillis = 10000;

    public CSPServerTokenURLConnectionFactory(String cspBaseURL, String cspClientId, String cspClientSecret, String cspOrgId) {
        this.cspBaseURL = cspBaseURL;
        this.cspClientId = cspClientId;
        this.cspClientSecret = cspClientSecret;
        this.cspOrgId = cspOrgId;
        String postData = "grant_type=client_credentials";
        if (!Utils.isNullOrEmpty(cspOrgId)) {
            postData = postData + "&orgId=" + cspOrgId;
        }
        this.postData = postData.getBytes(StandardCharsets.UTF_8);
    }

    public CSPServerTokenURLConnectionFactory(String cspBaseURL, String cspClientId, String cspClientSecret, String cspOrgId, int connectTimeoutMillis, int readTimeoutMillis) {
        this(cspBaseURL, cspClientId, cspClientSecret, cspOrgId);
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.readTimeoutMillis = readTimeoutMillis;
    }

    @Override
    public HttpURLConnection build() throws IOException {
        URL url = new URL(this.cspBaseURL + OAUTH_PATH);
        HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
        urlConn.setDoOutput(true);
        urlConn.setConnectTimeout(this.connectTimeoutMillis);
        urlConn.setReadTimeout(this.readTimeoutMillis);
        urlConn.setRequestMethod("POST");
        urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        urlConn.setRequestProperty("Accept", "application/json");
        urlConn.setRequestProperty("Content-Length", Integer.toString(this.postData.length));
        urlConn.setRequestProperty("Authorization", "Basic " + this.buildHttpBasicToken(this.cspClientId, this.cspClientSecret));
        return urlConn;
    }

    @Override
    public byte[] getPostData() {
        return this.postData;
    }

    private String buildHttpBasicToken(String cspClientId, String cspClientSecret) {
        String encodeMe = cspClientId + ":" + cspClientSecret;
        return Base64.getEncoder().encodeToString(encodeMe.getBytes());
    }

    @Override
    public String getType() {
        return TYPE;
    }
}

