/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.entities.events;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.wavefront.sdk.common.annotation.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class EventDTO {
    private final String name;
    private final long startTime;
    private final long endTime;
    private final List<String> hosts;
    private final List<String> tags;
    private final Map<String, String> annotations;

    public EventDTO(String name, long startTime, long endTime, String source, Map<String, String> annotations, @Nullable List<String> listTags) {
        this.name = name;
        this.startTime = startTime;
        this.endTime = endTime;
        this.hosts = Collections.singletonList(source);
        this.tags = listTags;
        this.annotations = annotations;
    }

    public String getName() {
        return this.name;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public List<String> getHosts() {
        return this.hosts;
    }

    public List<String> getTags() {
        if (this.tags == null) {
            return null;
        }
        return Collections.unmodifiableList(this.tags);
    }

    public Map<String, String> getAnnotations() {
        return Collections.unmodifiableMap(this.annotations);
    }
}

