/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.entities.tracing.sampling;

import com.wavefront.sdk.entities.tracing.sampling.CompositeSampler;
import com.wavefront.sdk.entities.tracing.sampling.Sampler;
import java.util.List;

public class MinConditionalSampler
extends CompositeSampler {
    private volatile long minimumDurationMillis;

    public MinConditionalSampler(List<Sampler> samplers, long minimumDurationMillis) {
        super(samplers);
        this.minimumDurationMillis = minimumDurationMillis;
    }

    @Override
    public boolean sample(String operationName, long traceId, long duration) {
        if (duration < this.minimumDurationMillis) {
            return false;
        }
        return super.sample(operationName, traceId, duration);
    }

    public void setMinimumDurationMillis(long minimumDurationMillis) {
        this.minimumDurationMillis = minimumDurationMillis;
    }
}

