/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.proxy;

import com.wavefront.sdk.common.BufferFlusher;
import com.wavefront.sdk.common.ReconnectingSocket;
import com.wavefront.sdk.common.metrics.WavefrontSdkCounter;
import com.wavefront.sdk.common.metrics.WavefrontSdkMetricsRegistry;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import javax.net.SocketFactory;

public class ProxyConnectionHandler
implements BufferFlusher,
Closeable {
    private final InetSocketAddress address;
    private final SocketFactory socketFactory;
    private volatile ReconnectingSocket reconnectingSocket;
    private final WavefrontSdkMetricsRegistry sdkMetricsRegistry;
    private String entityPrefix;
    private WavefrontSdkCounter errors;
    private WavefrontSdkCounter connectErrors;

    ProxyConnectionHandler(InetSocketAddress address, SocketFactory socketFactory, WavefrontSdkMetricsRegistry sdkMetricsRegistry, String entityPrefix) {
        this.address = address;
        this.socketFactory = socketFactory;
        this.reconnectingSocket = null;
        this.sdkMetricsRegistry = sdkMetricsRegistry;
        this.entityPrefix = entityPrefix == null || entityPrefix.isEmpty() ? "" : entityPrefix + ".";
        this.errors = this.sdkMetricsRegistry.newCounter(this.entityPrefix + "errors");
        this.connectErrors = this.sdkMetricsRegistry.newCounter(this.entityPrefix + "connect.errors");
    }

    synchronized void connect() throws IllegalStateException, IOException {
        if (this.reconnectingSocket != null) {
            throw new IllegalStateException("Already connected");
        }
        try {
            this.reconnectingSocket = new ReconnectingSocket(this.address.getHostName(), this.address.getPort(), this.socketFactory, this.sdkMetricsRegistry, this.entityPrefix + "socket");
        }
        catch (Exception e) {
            this.connectErrors.inc();
            throw new IOException(e);
        }
    }

    boolean isConnected() {
        return this.reconnectingSocket != null;
    }

    @Override
    public int getFailureCount() {
        return (int)this.errors.count();
    }

    void incrementFailureCount() {
        this.errors.inc();
    }

    @Override
    public void flush() throws IOException {
        if (this.isConnected()) {
            this.reconnectingSocket.flush();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.isConnected()) {
            this.reconnectingSocket.close();
            this.reconnectingSocket = null;
        }
    }

    void sendData(String lineData) throws Exception {
        if (!this.isConnected()) {
            try {
                this.connect();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.reconnectingSocket.write(lineData);
    }
}

