/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.proxy;

import com.wavefront.sdk.common.BufferFlusher;
import com.wavefront.sdk.common.ReconnectingSocket;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.SocketFactory;

public class ProxyConnectionHandler
implements BufferFlusher,
Closeable {
    private final InetSocketAddress address;
    private final SocketFactory socketFactory;
    private volatile ReconnectingSocket reconnectingSocket;
    private final AtomicInteger failures;

    protected ProxyConnectionHandler(InetSocketAddress address, SocketFactory socketFactory) {
        this.address = address;
        this.socketFactory = socketFactory;
        this.reconnectingSocket = null;
        this.failures = new AtomicInteger();
    }

    public synchronized void connect() throws IllegalStateException, IOException {
        if (this.reconnectingSocket != null) {
            throw new IllegalStateException("Already connected");
        }
        try {
            this.reconnectingSocket = new ReconnectingSocket(this.address.getHostName(), this.address.getPort(), this.socketFactory);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public boolean isConnected() {
        return this.reconnectingSocket != null;
    }

    @Override
    public int getFailureCount() {
        return this.failures.get();
    }

    public void incrementFailureCount() {
        this.failures.incrementAndGet();
    }

    @Override
    public void flush() throws IOException {
        if (this.reconnectingSocket != null) {
            this.reconnectingSocket.flush();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.reconnectingSocket != null) {
            this.reconnectingSocket.close();
            this.reconnectingSocket = null;
        }
    }

    protected void sendData(String lineData) throws Exception {
        this.reconnectingSocket.write(lineData);
    }
}

