/*
 * Decompiled with CFR 0.152.
 */
package com.warrenstrange.googleauth;

import com.warrenstrange.googleauth.GoogleAuthenticatorException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

class ReseedingSecureRandom {
    private static final int MAX_OPERATIONS = 1000000;
    private final String provider;
    private final String algorithm;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();
    private final AtomicInteger count = new AtomicInteger(0);
    private SecureRandom secureRandom;

    ReseedingSecureRandom() {
        this.algorithm = null;
        this.provider = null;
        this.buildSecureRandom();
    }

    ReseedingSecureRandom(String algorithm) {
        if (algorithm == null) {
            throw new IllegalArgumentException("Algorithm cannot be null.");
        }
        this.algorithm = algorithm;
        this.provider = null;
        this.buildSecureRandom();
    }

    ReseedingSecureRandom(String algorithm, String provider) {
        if (algorithm == null) {
            throw new IllegalArgumentException("Algorithm cannot be null.");
        }
        if (provider == null) {
            throw new IllegalArgumentException("Provider cannot be null.");
        }
        this.algorithm = algorithm;
        this.provider = provider;
        this.buildSecureRandom();
    }

    private void buildSecureRandom() {
        try {
            System.out.println("Building secure random instance: " + this.count.get());
            this.secureRandom = this.algorithm == null && this.provider == null ? new SecureRandom() : (this.provider == null ? SecureRandom.getInstance(this.algorithm) : SecureRandom.getInstance(this.algorithm, this.provider));
        }
        catch (NoSuchAlgorithmException e) {
            throw new GoogleAuthenticatorException(String.format("Could not initialise SecureRandom with the specified algorithm: %s", this.algorithm), e);
        }
        catch (NoSuchProviderException e) {
            throw new GoogleAuthenticatorException(String.format("Could not initialise SecureRandom with the specified provider: %s", this.provider), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void nextBytes(byte[] bytes) {
        this.readLock.lock();
        int currentCount = this.count.incrementAndGet();
        if (currentCount > 1000000) {
            this.readLock.unlock();
            this.writeLock.lock();
            try {
                currentCount = this.count.get();
                if (currentCount > 1000000) {
                    this.buildSecureRandom();
                    this.count.set(0);
                }
                this.readLock.lock();
            }
            finally {
                this.writeLock.unlock();
            }
        }
        try {
            this.secureRandom.nextBytes(bytes);
        }
        finally {
            this.readLock.unlock();
        }
    }
}

