/*
 * Decompiled with CFR 0.152.
 */
package com.wanderingcan.persistentsearch.drawables;

import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.support.annotation.FloatRange;

public class DrawerArrowDrawable
extends android.support.v7.graphics.drawable.DrawerArrowDrawable {
    public static final float HAMBURGER = 0.0f;
    public static final float ARROW = 1.0f;
    private ValueAnimator mToArrow;
    private ValueAnimator mToHam;
    private float mPosition;

    public DrawerArrowDrawable(Context context) {
        super(context);
        super.setSpinEnabled(true);
        this.mToArrow = ObjectAnimator.ofFloat((Object)((Object)this), (String)"position", (float[])new float[]{0.0f, 1.0f});
        this.mToHam = ObjectAnimator.ofFloat((Object)((Object)this), (String)"position", (float[])new float[]{1.0f, 0.0f});
        this.mPosition = 0.0f;
    }

    public void toggle() {
        if (this.mPosition == 0.0f) {
            this.animateToArrow();
        }
        if (this.mPosition == 1.0f) {
            this.animateToHamburger();
        }
    }

    public void animateToArrow() {
        this.mToHam.cancel();
        this.mToArrow.start();
    }

    public void animateToHamburger() {
        this.mToArrow.cancel();
        this.mToHam.start();
    }

    public void setDuration(long duration) {
        if (duration < 0L) {
            throw new IllegalArgumentException("Animations cannot have negative duration: " + duration);
        }
        this.mToArrow.setDuration(duration);
        this.mToHam.setDuration(duration);
    }

    public void setPosition(@FloatRange(from=0.0, to=1.0) float position) {
        if (position == 1.0f) {
            this.mPosition = 1.0f;
            this.setVerticalMirror(true);
        } else if (position == 0.0f) {
            this.mPosition = 0.0f;
            this.setVerticalMirror(false);
        }
        super.setProgress(position);
    }

    public float getPosition() {
        return super.getProgress();
    }
}

