/*
 * Decompiled with CFR 0.152.
 */
package com.wanderingcan.persistentsearch;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.wanderingcan.persistentsearch.SearchMenu;
import com.wanderingcan.persistentsearch.SearchMenuItem;
import com.wanderingcan.widget.R;

class SearchMenuPresenter {
    private Context mContext;
    private SearchMenu mMenu;
    private SearchMenuAdapter mAdapter;
    private SearchMenuItemListener mListener;

    public SearchMenuPresenter(Context context, SearchMenuItemListener listener) {
        this.mContext = context;
        this.mMenu = new SearchMenu(this);
        this.mAdapter = new SearchMenuAdapter();
        this.mListener = listener;
    }

    public Context getContext() {
        return this.mContext;
    }

    public SearchMenuAdapter getAdapter() {
        return this.mAdapter;
    }

    public SearchMenu getMenu() {
        return this.mMenu;
    }

    private class ViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener {
        public final TextView mTitle;
        public final ImageView mIcon;
        public final ImageView mAction;

        public ViewHolder(View itemView) {
            super(itemView);
            itemView.setOnClickListener((View.OnClickListener)this);
            this.mTitle = (TextView)itemView.findViewById(R.id.content_title);
            this.mIcon = (ImageView)itemView.findViewById(R.id.content_display_icon);
            this.mAction = (ImageView)itemView.findViewById(R.id.content_action_icon);
            this.mAction.setOnClickListener((View.OnClickListener)this);
        }

        public void onClick(View v) {
            if (SearchMenuPresenter.this.mListener != null) {
                if (v.equals(this.mAction)) {
                    SearchMenuItem item = SearchMenuPresenter.this.mMenu.getItems().get(this.getAdapterPosition());
                    SearchMenuPresenter.this.mListener.onActionClick(item, item.isDefaultAction());
                }
                if (v.equals(this.itemView)) {
                    SearchMenuPresenter.this.mListener.onItemClick(SearchMenuPresenter.this.mMenu.getItems().get(this.getAdapterPosition()));
                }
            }
        }
    }

    protected class SearchMenuAdapter
    extends RecyclerView.Adapter<ViewHolder> {
        protected SearchMenuAdapter() {
        }

        public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
            View view = inflater.inflate(R.layout.content_searchmenu_item, parent, false);
            return new ViewHolder(view);
        }

        public void onBindViewHolder(ViewHolder holder, int position) {
            SearchMenuItem item = SearchMenuPresenter.this.mMenu.getItems().get(position);
            holder.mTitle.setText((CharSequence)item.getTitle());
            holder.mIcon.setImageDrawable(item.getIcon());
            holder.mAction.setImageDrawable(item.getActionIcon());
        }

        public int getItemCount() {
            return SearchMenuPresenter.this.mMenu.getCount();
        }
    }

    public static interface SearchMenuItemListener {
        public void onItemClick(SearchMenuItem var1);

        public void onActionClick(SearchMenuItem var1, boolean var2);
    }
}

