/*
 * Decompiled with CFR 0.152.
 */
package com.wanderingcan.persistentsearch;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.TintManager;
import com.wanderingcan.persistentsearch.SearchMenuPresenter;
import com.wanderingcan.widget.R;

public class SearchMenuItem
implements Comparable<SearchMenuItem> {
    public static final int NO_ICON = 0;
    private final int mOrdering;
    private final int mId;
    private Drawable mIconDrawable;
    private int mIconResId = 0;
    private String mTitle;
    private Drawable mActionDrawable;
    private int mActionResId = 0;
    private boolean mDefaultAction;
    private SearchMenuPresenter mMenu;

    private SearchMenuItem() {
        this.mId = 0;
        this.mOrdering = 0;
    }

    SearchMenuItem(SearchMenuPresenter presenter, int id, int ordering, String title) {
        this.mMenu = presenter;
        this.mId = id;
        this.mOrdering = ordering;
        this.mTitle = title;
        this.mActionDrawable = ContextCompat.getDrawable((Context)this.mMenu.getContext(), (int)R.drawable.ic_action_arrow);
        this.mDefaultAction = true;
    }

    protected boolean isDefaultAction() {
        return this.mDefaultAction;
    }

    public int getId() {
        return this.mId;
    }

    public int getOrdering() {
        return this.mOrdering;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public SearchMenuItem setTitle(String title) {
        this.mTitle = title = title.trim();
        int index = this.mMenu.getMenu().getItems().indexOf(this);
        this.mMenu.getAdapter().notifyItemChanged(index);
        return this;
    }

    public SearchMenuItem setTitle(@StringRes int resId) {
        Context context = this.mMenu.getContext();
        String title = context.getString(resId);
        return this.setTitle(title);
    }

    public Drawable getActionIcon() {
        if (this.mActionDrawable != null) {
            return this.mActionDrawable;
        }
        if (this.mActionResId != 0) {
            Drawable icon = TintManager.getDrawable((Context)this.mMenu.getContext(), (int)this.mActionResId);
            this.mActionResId = 0;
            this.mActionDrawable = icon;
            return icon;
        }
        return null;
    }

    public SearchMenuItem setActionIcon(Drawable icon) {
        this.mDefaultAction = false;
        this.mActionResId = 0;
        this.mActionDrawable = icon;
        int index = this.mMenu.getMenu().getItems().indexOf(this);
        this.mMenu.getAdapter().notifyItemChanged(index);
        return this;
    }

    public SearchMenuItem setActionIcon(@DrawableRes int iconResId) {
        this.mDefaultAction = false;
        this.mActionDrawable = null;
        this.mActionResId = iconResId;
        int index = this.mMenu.getMenu().getItems().indexOf(this);
        this.mMenu.getAdapter().notifyItemChanged(index);
        return this;
    }

    public Drawable getIcon() {
        if (this.mIconDrawable != null) {
            return this.mIconDrawable;
        }
        if (this.mIconResId != 0) {
            Drawable icon = TintManager.getDrawable((Context)this.mMenu.getContext(), (int)this.mIconResId);
            this.mIconResId = 0;
            this.mIconDrawable = icon;
            return icon;
        }
        return null;
    }

    public SearchMenuItem setIcon(Drawable icon) {
        this.mIconResId = 0;
        this.mIconDrawable = icon;
        int index = this.mMenu.getMenu().getItems().indexOf(this);
        this.mMenu.getAdapter().notifyItemChanged(index);
        return this;
    }

    public SearchMenuItem setIcon(@DrawableRes int iconResId) {
        this.mIconDrawable = null;
        this.mIconResId = iconResId;
        int index = this.mMenu.getMenu().getItems().indexOf(this);
        this.mMenu.getAdapter().notifyItemChanged(index);
        return this;
    }

    public String toString() {
        return "SearchMenuItem{\nId = " + this.mId + "\nTitle = '" + this.mTitle + '\'' + "\nOrdering = " + this.mOrdering + '}';
    }

    @Override
    public int compareTo(@NonNull SearchMenuItem another) {
        return this.mOrdering - another.mOrdering;
    }
}

