/*
 * Decompiled with CFR 0.152.
 */
package com.walterjwhite.file.providers.amazon.service;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.walterjwhite.amazon.property.AmazonRegion;
import com.walterjwhite.datastore.criteria.Repository;
import com.walterjwhite.encryption.api.service.CompressionService;
import com.walterjwhite.encryption.api.service.DigestService;
import com.walterjwhite.encryption.api.service.EncryptionService;
import com.walterjwhite.file.impl.service.AbstractFileStorageService;
import com.walterjwhite.file.providers.amazon.service.AmazonS3Bucket;
import com.walterjwhite.google.guice.property.enumeration.Debug;
import com.walterjwhite.google.guice.property.enumeration.NoOperation;
import com.walterjwhite.google.guice.property.enumeration.ProxyType;
import com.walterjwhite.google.guice.property.property.Property;
import com.walterjwhite.google.guice.property.property.ProxyHost;
import com.walterjwhite.google.guice.property.property.ProxyPort;
import java.io.File;
import java.io.FileOutputStream;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmazonS3FileStorageService
extends AbstractFileStorageService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmazonS3FileStorageService.class);
    protected final String bucketName;
    protected final AmazonS3 s3client;

    @Inject
    public AmazonS3FileStorageService(CompressionService compressionService, EncryptionService encryptionService, DigestService digestService, Repository repository, @Property(value=NoOperation.class) boolean nop, @Property(value=Debug.class) boolean debug, @Property(value=com.walterjwhite.google.guice.property.property.ProxyType.class) ProxyType proxyType, @Property(value=ProxyHost.class) String proxyHost, @Property(value=ProxyPort.class) int proxyPort, @Property(value=AmazonS3Bucket.class) String bucketName, @Property(value=AmazonRegion.class) Regions region) {
        super(compressionService, encryptionService, digestService, repository, nop, debug);
        this.bucketName = bucketName;
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        if (ProxyType.HTTP.equals((Object)proxyType)) {
            clientConfiguration.setProtocol(Protocol.HTTP);
        }
        clientConfiguration.setProxyHost(proxyHost);
        clientConfiguration.setProxyPort(proxyPort);
        this.s3client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withRegion(region)).withClientConfiguration(clientConfiguration)).build();
    }

    protected void doPut(com.walterjwhite.file.api.model.File file) {
        LOGGER.info("file bucket:" + this.bucketName);
        LOGGER.info("file checksum:" + file.getId());
        LOGGER.info("file source:" + file.getSource());
        PutObjectResult putObjectResult = this.s3client.putObject(this.bucketName, file.getId(), new File(file.getSource()));
    }

    public void doGet(com.walterjwhite.file.api.model.File file) {
        try {
            S3Object s3Object = this.s3client.getObject(this.bucketName, file.getId());
            File outputFile = File.createTempFile(file.getId(), "s3");
            try (FileOutputStream fos = new FileOutputStream(outputFile);){
                int read;
                while ((read = s3Object.getObjectContent().read()) >= 0) {
                    fos.write(read);
                }
                file.setSource(outputFile.getAbsolutePath());
            }
        }
        catch (Exception e) {
            LOGGER.error("Error retrieving file", (Throwable)e);
            throw new RuntimeException("Error retrieving file", e);
        }
    }

    public void delete(com.walterjwhite.file.api.model.File file) {
        this.s3client.deleteObject(this.bucketName, file.getId());
    }
}

