/*
 * Decompiled with CFR 0.152.
 */
package com.walletone.sdk.managers;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.walletone.sdk.Manager;
import com.walletone.sdk.P2PCore;
import com.walletone.sdk.library.CompleteHandler;
import com.walletone.sdk.library.URLComposer;
import com.walletone.sdk.managers.NetworkManager;
import com.walletone.sdk.models.RefundsResult;
import java.util.ArrayList;
import java.util.Locale;

public class RefundsManager
extends Manager {
    private Composer composer = new Composer();

    public RefundsManager(P2PCore core) {
        super(core);
    }

    public RefundsResult refunds(int pageNumber, int itemsPerPage, String dealId, CompleteHandler<RefundsResult, Throwable> callback) {
        String url = this.composer.payersRefunds(this.core.getPayerId(), pageNumber, itemsPerPage, dealId);
        return this.core.networkManager.request(url, NetworkManager.MethodType.GET, null, RefundsResult.class, callback);
    }

    class Composer
    extends URLComposer {
        Composer() {
        }

        String payers() {
            return Composer.getInstance().relativeToApi("payers");
        }

        String payers(String id) {
            return Composer.getInstance().relative(this.payers(), id);
        }

        String payersRefunds(@NonNull String id, int pageNumber, int itemsPerPage, String dealId) {
            ArrayList<String> items = new ArrayList<String>();
            items.add(String.format(Locale.US, "pageNumber=%d", pageNumber));
            items.add(String.format(Locale.US, "itemsPerPage=%d", itemsPerPage));
            if (dealId != null) {
                items.add(String.format(Locale.US, "dealId=%s", dealId));
            }
            return Composer.getInstance().relative(this.payers(id), "refunds?" + TextUtils.join((CharSequence)"&", items));
        }
    }
}

