/*
 * Decompiled with CFR 0.152.
 */
package com.walletone.sdk.managers;

import android.os.AsyncTask;
import com.walletone.sdk.Manager;
import com.walletone.sdk.P2PCore;
import com.walletone.sdk.W1P2PException;
import com.walletone.sdk.internal.Utility;
import com.walletone.sdk.library.Base64;
import com.walletone.sdk.library.CompleteErrorOnlyHandler;
import com.walletone.sdk.library.CompleteHandler;
import com.walletone.sdk.library.Mapper;
import com.walletone.sdk.library.ModelFactory;
import com.walletone.sdk.models.RequestBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class NetworkManager
extends Manager {
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String ISO_8601_FORMAT_STRING = "yyyy-MM-dd'T'HH:mm:ssZ";
    public final String P2P_RESPONSE_STRING_KEY = "P2PResponseStringKey";
    public final String P2P_RESPONSE_ERROR_CODE_KEY = "P2PResponseErrorCodeKey";
    private InputStream dataStream;
    private List<InputStream> dataStreamList = new ArrayList<InputStream>();

    public NetworkManager(P2PCore core) {
        super(core);
    }

    private String makeSignature(String urlString, String timestamp, String requestBody) {
        String base64;
        StringBuilder sb = new StringBuilder();
        sb.append(urlString).append(timestamp).append(requestBody).append(this.core.getSignatureKey());
        byte[] signatureValue = NetworkManager.getSha256(sb.toString());
        try {
            base64 = Base64.encode(signatureValue);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return base64;
    }

    public String makeSignatureForWeb(Map<String, String> parameters) {
        String base64;
        TreeMap<String, String> treeMap = new TreeMap<String, String>(parameters);
        StringBuilder sb = new StringBuilder();
        for (String value : treeMap.values()) {
            sb.append(value);
        }
        sb.append(this.core.getSignatureKey());
        byte[] signatureValue = NetworkManager.getSha256(sb.toString());
        try {
            base64 = Base64.encode(signatureValue);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return base64;
    }

    public static byte[] getSha256(String base) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            return digest.digest(base.getBytes("UTF-8"));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public <T extends Mapper.Mappable> List<T> requestList(String urlString, MethodType method, Map<String, Object> parameters, final Class<T> cls, final CompleteHandler<List<T>, Throwable> callback) {
        this.requestWithPrint(urlString, method, parameters, new CompleteHandler<Object, Throwable>(){

            @Override
            public void completed(Object json, Throwable error) {
                if (error == null) {
                    ArrayList<Mapper.Mappable> listT = new ArrayList<Mapper.Mappable>();
                    JSONArray jArray = (JSONArray)json;
                    if (jArray != null) {
                        for (int i = 0; i < jArray.length(); ++i) {
                            Mapper.Mappable t = (Mapper.Mappable)ModelFactory.newInstance(cls, (JSONObject)jArray.opt(i));
                            listT.add(t);
                        }
                    }
                    callback.completed(listT, null);
                } else {
                    callback.completed(null, error);
                }
            }
        });
        return null;
    }

    public <T extends Mapper.Mappable> T request(String urlString, MethodType method, Map<String, Object> parameters, final Class<?> cls, final CompleteHandler<T, Throwable> callback) {
        this.requestWithPrint(urlString, method, parameters, new CompleteHandler<Object, Throwable>(){

            @Override
            public void completed(Object json, Throwable error) {
                if (error == null) {
                    try {
                        Mapper.Mappable instance = (Mapper.Mappable)ModelFactory.newInstance(cls, (JSONObject)json);
                        callback.completed(instance, null);
                    }
                    catch (ClassCastException ex) {
                        callback.completed(null, ex);
                    }
                } else {
                    callback.completed(null, error);
                }
            }
        });
        return null;
    }

    public void request(String urlString, MethodType method, Map<String, Object> parameters, final CompleteErrorOnlyHandler<Throwable> callback) {
        this.requestWithPrint(urlString, method, parameters, new CompleteHandler<Object, Throwable>(){

            @Override
            public void completed(Object json, Throwable error) {
                callback.completed(error);
            }
        });
    }

    private JSONObject requestWithPrint(String urlString, MethodType method, Map<String, Object> parameters, CompleteHandler<Object, Throwable> callback) {
        String timestamp = ISO8601TimeStamp.getISO8601TimeStamp(new Date());
        String bodyAsString = "";
        RequestBuilder.Builder requestBuilder = RequestBuilder.newBuilder();
        requestBuilder.setMethodType(method).setTimestamp(timestamp).setUrlString(urlString);
        try {
            if (parameters != null) {
                JSONObject jsonObject = new JSONObject();
                for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                    jsonObject.put(entry.getKey(), entry.getValue());
                }
                bodyAsString = jsonObject.toString();
                requestBuilder.setHttpBody(bodyAsString);
            }
        }
        catch (JSONException ex) {
            ex.printStackTrace();
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
        String signature = this.makeSignature(urlString, timestamp, bodyAsString);
        requestBuilder.setSignature(signature);
        LoadDataAsync task = new LoadDataAsync(callback);
        task.execute(new RequestBuilder[]{requestBuilder.build()});
        return null;
    }

    private HttpURLConnection toHttpConnection(RequestBuilder requests) {
        HttpURLConnection connection;
        URL url;
        try {
            url = new URL(requests.getUrlString());
        }
        catch (MalformedURLException e) {
            throw new W1P2PException("could not construct URL for request", e);
        }
        try {
            connection = this.createConnection(url);
            connection.setConnectTimeout(5000);
            connection.setRequestMethod(requests.getMethodType().getMethodTypeId());
            connection.setRequestProperty("X-Wallet-PlatformId", this.core.getPlatformId());
            connection.setRequestProperty("X-Wallet-Timestamp", requests.getTimestamp());
            connection.setRequestProperty("X-Wallet-Signature", requests.getSignature());
        }
        catch (IOException e) {
            throw new W1P2PException("could not construct request body", e);
        }
        return connection;
    }

    private HttpURLConnection createConnection(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty(CONTENT_TYPE_HEADER, "application/json; charset=utf-8");
        return connection;
    }

    private void printResponseDebugData(HttpURLConnection urlConnection, String responseString) throws IOException {
        P2PCore.INSTANCE.printDebug("=======");
        P2PCore.INSTANCE.printDebug("SERVER RESPONSE");
        P2PCore.INSTANCE.printDebug("Code:" + urlConnection.getResponseCode() + " Message: " + urlConnection.getResponseMessage());
        P2PCore.INSTANCE.printDebug("Response string:");
        P2PCore.INSTANCE.printDebug(responseString);
        P2PCore.INSTANCE.printDebug("=======");
    }

    private void printRequestDebugData(HttpURLConnection connection, RequestBuilder request) {
        P2PCore.INSTANCE.printDebug("=======");
        P2PCore.INSTANCE.printDebug("BEGIN NEW REQUEST");
        P2PCore.INSTANCE.printDebug(request.getMethodType().getMethodTypeId() + " \\ " + request.getUrlString());
        P2PCore.INSTANCE.printDebug("BODY:(" + request.getHttpBody() + ")");
        P2PCore.INSTANCE.printDebug("Headers:");
        for (Map.Entry<String, List<String>> entries : connection.getRequestProperties().entrySet()) {
            StringBuilder values = new StringBuilder();
            for (String value : entries.getValue()) {
                values.append(value);
            }
            P2PCore.INSTANCE.printDebug(entries.getKey() + " - " + values);
        }
        P2PCore.INSTANCE.printDebug("END NEW REQUEST");
        P2PCore.INSTANCE.printDebug("=======");
    }

    private void printErrorDebug(W1P2PException exception) {
        P2PCore.INSTANCE.printDebug("=======");
        P2PCore.INSTANCE.printDebug("ERROR:");
        P2PCore.INSTANCE.printDebug("Localized message: " + exception.getLocalizedMessage());
        P2PCore.INSTANCE.printDebug("Message: " + exception.getMessage());
        P2PCore.INSTANCE.printDebug("=======");
    }

    static class ISO8601TimeStamp {
        ISO8601TimeStamp() {
        }

        public static String getISO8601TimeStamp(Date date) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US);
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            return dateFormat.format(date);
        }
    }

    class LoadDataAsync
    extends AsyncTask<RequestBuilder, Void, Object> {
        private final CompleteHandler<Object, Throwable> callback;
        private W1P2PException exception;

        private LoadDataAsync(CompleteHandler<Object, Throwable> callback) {
            this.callback = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        protected Object doInBackground(RequestBuilder ... request) {
            Object resultObject;
            InputStream stream;
            block9: {
                HttpURLConnection urlConnection = NetworkManager.this.toHttpConnection(request[0]);
                NetworkManager.this.printRequestDebugData(urlConnection, request[0]);
                stream = null;
                resultObject = null;
                try {
                    String responseString;
                    if (request[0].getHttpBody() != null) {
                        OutputStream os = urlConnection.getOutputStream();
                        os.write(request[0].getHttpBody().getBytes("UTF-8"));
                        os.close();
                    }
                    if (urlConnection.getResponseCode() >= 400) {
                        stream = urlConnection.getErrorStream();
                        responseString = Utility.readStreamToString(stream);
                        JSONTokener tokener = new JSONTokener(responseString);
                        resultObject = tokener.nextValue();
                        this.exception = new W1P2PException(((JSONObject)resultObject).getString("ErrorDescription"));
                        NetworkManager.this.printErrorDebug(this.exception);
                        break block9;
                    }
                    stream = urlConnection.getInputStream();
                    responseString = Utility.readStreamToString(stream);
                    JSONTokener tokener = new JSONTokener(responseString);
                    resultObject = tokener.nextValue();
                    if (!("DELETE".equals(urlConnection.getRequestMethod()) || resultObject instanceof JSONObject || resultObject instanceof JSONArray)) {
                        this.exception = new W1P2PException("Server returned non-json data");
                        NetworkManager.this.printErrorDebug(this.exception);
                    }
                    NetworkManager.this.printResponseDebugData(urlConnection, responseString);
                }
                catch (JSONException e) {
                    this.exception = new W1P2PException("could not parse json data", e);
                    NetworkManager.this.printErrorDebug(this.exception);
                    Utility.closeQuietly(stream);
                }
                catch (IOException e2) {
                    this.exception = new W1P2PException("could not get data", e2);
                    NetworkManager.this.printErrorDebug(this.exception);
                    {
                        catch (Throwable throwable) {
                            Utility.closeQuietly(stream);
                            throw throwable;
                        }
                    }
                    Utility.closeQuietly(stream);
                }
            }
            Utility.closeQuietly(stream);
            return resultObject;
        }

        protected void onPostExecute(Object result) {
            if (this.callback != null) {
                if (this.exception == null) {
                    this.callback.completed(result, null);
                } else {
                    this.callback.completed(null, this.exception);
                }
            }
        }
    }

    public static enum MethodType {
        GET("GET"),
        POST("POST"),
        PUT("PUT"),
        DELETE("DELETE"),
        UNKNOWN("");

        private String id;

        private MethodType(String id) {
            this.id = id;
        }

        public String getMethodTypeId() {
            return this.id;
        }

        public static MethodType fromId(String id) {
            for (MethodType type : MethodType.values()) {
                if (!type.getMethodTypeId().equals(id)) continue;
                return type;
            }
            return UNKNOWN;
        }
    }
}

