/*
 * Decompiled with CFR 0.152.
 */
package com.walletone.sdk.managers;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.walletone.sdk.Manager;
import com.walletone.sdk.P2PCore;
import com.walletone.sdk.constants.CurrencyId;
import com.walletone.sdk.library.CompleteHandler;
import com.walletone.sdk.library.URLComposer;
import com.walletone.sdk.managers.NetworkManager;
import com.walletone.sdk.models.Deal;
import com.walletone.sdk.models.DealsResult;
import com.walletone.sdk.models.RequestBuilder;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public class DealsManager
extends Manager {
    private Composer composer = new Composer();

    public DealsManager(P2PCore core) {
        super(core);
    }

    public Deal create(String dealId, String beneficiaryId, Integer payerPaymentToolId, Integer beneficiaryPaymentToolId, BigDecimal amount, CurrencyId currencyId, String shortDescription, String fullDescription, boolean deferPayout, CompleteHandler<Deal, Throwable> callback) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("PlatformDealId", dealId);
        params.put("PlatformPayerId", this.core.getPayerId());
        params.put("PayerPhoneNumber", this.core.getPayerPhoneNumber());
        params.put("PlatformBeneficiaryId", beneficiaryId);
        params.put("BeneficiaryPaymentToolId", beneficiaryPaymentToolId);
        params.put("Amount", amount);
        params.put("CurrencyId", currencyId.getId());
        params.put("ShortDescription", shortDescription);
        params.put("FullDescription", fullDescription);
        params.put("DeferPayout", deferPayout ? "true" : "false");
        if (payerPaymentToolId != null) {
            params.put("PayerPaymentToolId", payerPaymentToolId);
        }
        return this.core.networkManager.request(this.composer.deals(), NetworkManager.MethodType.POST, params, Deal.class, callback);
    }

    public Deal complete(String dealId, CompleteHandler<Deal, Throwable> callback) {
        return this.core.networkManager.request(this.composer.dealsComplete(dealId), NetworkManager.MethodType.PUT, null, Deal.class, callback);
    }

    public List<Deal> complete(@NonNull List<String> dealIds, @Nullable Integer paymentToolId, CompleteHandler<List<Deal>, Throwable> callback) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("PlatformDeals", dealIds);
        params.put("PaymentToolId", paymentToolId);
        return this.core.networkManager.requestList(this.composer.dealsComplete(), NetworkManager.MethodType.PUT, params, Deal.class, callback);
    }

    public Deal cancel(String dealId, CompleteHandler<Deal, Throwable> callback) {
        return this.core.networkManager.request(this.composer.dealsCancel(dealId), NetworkManager.MethodType.PUT, null, Deal.class, callback);
    }

    public Deal status(String dealId, CompleteHandler<Deal, Throwable> callback) {
        return this.core.networkManager.request(this.composer.deals(dealId), NetworkManager.MethodType.GET, null, Deal.class, callback);
    }

    public Deal set(Integer paymentToolId, String dealId, boolean autoComplete, CompleteHandler<Deal, Throwable> callback) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("PaymentToolId", paymentToolId);
        params.put("AutoComplete", autoComplete);
        return this.core.networkManager.request(this.composer.dealsBeneficiaryPaymentTool(dealId), NetworkManager.MethodType.PUT, params, Deal.class, callback);
    }

    public RequestBuilder payRequest(String dealId, @Nullable String paymentTypeId, @Nullable Boolean redirectToPaymentToolAddition, @Nullable String authData, String returnUrl) {
        String urlString = this.composer.dealPay();
        String timestamp = NetworkManager.ISO8601TimeStamp.getISO8601TimeStamp(new Date());
        TreeMap<String, String> items = new TreeMap<String, String>();
        items.put("PlatformDealId", dealId);
        items.put("PlatformId", this.core.getPlatformId());
        items.put("ReturnUrl", returnUrl);
        items.put("Timestamp", timestamp);
        if (paymentTypeId != null) {
            items.put("PaymentTypeId", paymentTypeId);
        }
        if (redirectToPaymentToolAddition != null) {
            items.put("RedirectToPaymentToolAddition", redirectToPaymentToolAddition != false ? "true" : "false");
        }
        if (authData != null && !authData.isEmpty()) {
            items.put("AuthData", authData);
        }
        String signature = this.core.networkManager.makeSignatureForWeb(items);
        items.put("Signature", signature);
        ArrayList<String> params = new ArrayList<String>();
        for (Map.Entry entry : items.entrySet()) {
            params.add(String.format("%s=%s", entry.getKey(), Uri.encode((String)((String)entry.getValue()), (String)"UTF-8")));
        }
        String queryString = TextUtils.join((CharSequence)"&", params);
        RequestBuilder.Builder builder = RequestBuilder.newBuilder().setMethodType(NetworkManager.MethodType.POST).setSignature(signature).setTimestamp(timestamp).setUrlString(urlString).setHttpBody(queryString);
        return builder.build();
    }

    public DealsResult getDeals(@NonNull String beneficiaryId, @NonNull Integer pageNumber, @NonNull Integer itemsPerPage, @Nullable List<String> dealStates, @Nullable String searchString, CompleteHandler<DealsResult, Throwable> callback) {
        return this.core.networkManager.request(this.composer.beneficiariesDeals(beneficiaryId, pageNumber, itemsPerPage, dealStates, searchString), NetworkManager.MethodType.GET, null, DealsResult.class, callback);
    }

    class Composer
    extends URLComposer {
        Composer() {
        }

        String deal() {
            return Composer.getInstance().relativeToBase("deal");
        }

        String dealPay() {
            return Composer.getInstance().relative(this.deal(), "pay");
        }

        String deals() {
            return Composer.getInstance().relativeToApi("deals");
        }

        String deals(String dealId) {
            return Composer.getInstance().relative(this.deals(), dealId);
        }

        String dealsComplete(String dealId) {
            return Composer.getInstance().relative(this.deals(dealId), "complete");
        }

        String dealsComplete() {
            return Composer.getInstance().relative(this.deals(), "complete");
        }

        String dealsCancel(String dealId) {
            return Composer.getInstance().relative(this.deals(dealId), "cancel");
        }

        String dealsBeneficiaryPaymentTool(String platformDealId) {
            return Composer.getInstance().relative(this.deals(platformDealId), "beneficiaryPaymentTool");
        }

        String beneficiaries() {
            return Composer.getInstance().relativeToApi("beneficiaries");
        }

        String beneficiaries(String id) {
            return Composer.getInstance().relative(this.beneficiaries(), id);
        }

        String beneficiariesDeals(String beneficiaryId, Integer pageNumber, Integer itemsPerPage, @Nullable List<String> dealStates, @Nullable String searchString) {
            ArrayList<String> params = new ArrayList<String>();
            params.add(String.format(Locale.US, "pageNumber=%d", pageNumber));
            params.add(String.format(Locale.US, "itemsPerPage=%d", itemsPerPage));
            if (dealStates != null && dealStates.size() > 0) {
                params.add(String.format(Locale.US, "dealStates=%s", TextUtils.join((CharSequence)",", dealStates)));
            }
            if (searchString != null) {
                params.add(String.format(Locale.US, "searchString=%s", searchString));
            }
            return Composer.getInstance().relative(this.beneficiaries(beneficiaryId), "deals?" + TextUtils.join((CharSequence)"&", params));
        }
    }
}

