/*
 * Decompiled with CFR 0.152.
 */
package com.walletone.sdk.managers;

import com.walletone.sdk.Manager;
import com.walletone.sdk.P2PCore;
import com.walletone.sdk.library.CompleteErrorOnlyHandler;
import com.walletone.sdk.library.CompleteHandler;
import com.walletone.sdk.library.URLComposer;
import com.walletone.sdk.managers.NetworkManager;
import com.walletone.sdk.models.PaymentTool;
import com.walletone.sdk.models.PaymentToolsResult;

public class PayersPaymentToolsManager
extends Manager {
    private Composer composer = new Composer();

    public PayersPaymentToolsManager(P2PCore core) {
        super(core);
    }

    public PaymentToolsResult paymentTools(CompleteHandler<PaymentToolsResult, Throwable> callback) {
        return this.core.networkManager.request(this.composer.payersTools(this.core.getPayerId()), NetworkManager.MethodType.GET, null, PaymentToolsResult.class, callback);
    }

    public PaymentTool paymentTool(Integer paymentToolId, CompleteHandler<PaymentTool, Throwable> callback) {
        return this.core.networkManager.request(this.composer.payersToolsTool(this.core.getBenificaryId(), paymentToolId), NetworkManager.MethodType.GET, null, PaymentTool.class, callback);
    }

    public void delete(Integer paymentToolId, CompleteErrorOnlyHandler callback) {
        this.core.networkManager.request(this.composer.payersToolsTool(this.core.getBenificaryId(), paymentToolId), NetworkManager.MethodType.DELETE, null, callback);
    }

    class Composer
    extends URLComposer {
        Composer() {
        }

        String payers() {
            return Composer.getInstance().relativeToApi("payers");
        }

        String payers(String id) {
            return Composer.getInstance().relative(this.payers(), id);
        }

        String payersTools(String id) {
            return Composer.getInstance().relative(this.payers(id), "tools");
        }

        String payersToolsTool(String id, Integer tool) {
            return Composer.getInstance().relative(this.payersTools(id), String.valueOf(tool));
        }
    }
}

