/*
 * Decompiled with CFR 0.152.
 */
package com.walletone.sdk.library;

import com.walletone.sdk.library.Environment;

public class URLComposer {
    private String SANDBOX_URL = "https://api.dev.walletone.com/p2p/";
    private String PRODUCT_URL = "https://api.w1.ru/p2p/";
    private int CURRENT_API_VERSION = 3;
    private String API_PATH = "api/v%s";
    private static URLComposer instance;
    private Environment environment = Environment.SANDBOX;

    public static URLComposer getInstance() {
        if (instance == null) {
            instance = new URLComposer();
        }
        return instance;
    }

    private String getProtocol() {
        switch (this.environment) {
            case SANDBOX: {
                return "https";
            }
            case PRODUCT: {
                return "https";
            }
        }
        return "https";
    }

    private String getBaseURL() {
        switch (this.environment) {
            case SANDBOX: {
                return this.SANDBOX_URL;
            }
            case PRODUCT: {
                return this.PRODUCT_URL;
            }
        }
        return this.SANDBOX_URL;
    }

    private String getApiURL() {
        return this.getBaseURL() + String.format(this.API_PATH, this.CURRENT_API_VERSION);
    }

    public String relativeToBase(String to) {
        return this.relative(this.getBaseURL(), to);
    }

    public String relativeToApi(String to) {
        return this.relative(this.getApiURL(), to);
    }

    public String relative(String base, String to) {
        if (base.endsWith("/")) {
            return base + to;
        }
        return base + "/" + to;
    }

    public void setEnvironment(Environment environment) {
        if (environment != null) {
            this.environment = environment;
        }
    }
}

