/*
 * Decompiled with CFR 0.152.
 */
package com.walletone.sdk.managers;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.walletone.sdk.Manager;
import com.walletone.sdk.P2PCore;
import com.walletone.sdk.library.CompleteHandler;
import com.walletone.sdk.library.URLComposer;
import com.walletone.sdk.managers.NetworkManager;
import com.walletone.sdk.models.PayoutResult;
import java.util.ArrayList;
import java.util.Locale;

public class PayoutsManager
extends Manager {
    private Composer composer = new Composer();

    public PayoutsManager(P2PCore core) {
        super(core);
    }

    public PayoutResult payouts(int pageNumber, int itemsPerPage, String dealId, CompleteHandler<PayoutResult, Throwable> callback) {
        String url = this.composer.beneficiariesPayouts(this.core.getBenificaryId(), pageNumber, itemsPerPage, dealId);
        return this.core.networkManager.request(url, NetworkManager.MethodType.GET, null, PayoutResult.class, callback);
    }

    class Composer
    extends URLComposer {
        Composer() {
        }

        String beneficiaries() {
            return Composer.getInstance().relativeToApi("beneficiaries");
        }

        String beneficiaries(String id) {
            return Composer.getInstance().relative(this.beneficiaries(), id);
        }

        String beneficiariesPayouts(@NonNull String id, int pageNumber, int itemsPerPage, String dealId) {
            ArrayList<String> items = new ArrayList<String>();
            items.add(String.format(Locale.US, "pageNumber=%d", pageNumber));
            items.add(String.format(Locale.US, "itemsPerPage=%d", itemsPerPage));
            if (dealId != null) {
                items.add(String.format(Locale.US, "dealId=%s", dealId));
            }
            return Composer.getInstance().relative(this.beneficiaries(id), "payouts?" + TextUtils.join((CharSequence)"&", items));
        }
    }
}

