/*
 * Decompiled with CFR 0.152.
 */
package com.walletone.sdk.managers;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.walletone.sdk.Manager;
import com.walletone.sdk.P2PCore;
import com.walletone.sdk.library.CompleteErrorOnlyHandler;
import com.walletone.sdk.library.CompleteHandler;
import com.walletone.sdk.library.URLComposer;
import com.walletone.sdk.managers.NetworkManager;
import com.walletone.sdk.models.PaymentTool;
import com.walletone.sdk.models.PaymentToolsResult;
import com.walletone.sdk.models.RequestBuilder;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;

public class BeneficiariesPaymentToolsManager
extends Manager {
    private Composer composer = new Composer();

    public BeneficiariesPaymentToolsManager(P2PCore core) {
        super(core);
    }

    public PaymentToolsResult paymentTools(CompleteHandler<PaymentToolsResult, Throwable> callback) {
        return this.core.networkManager.request(this.composer.beneficiariesTools(this.core.getBenificaryId()), NetworkManager.MethodType.GET, null, PaymentToolsResult.class, callback);
    }

    public PaymentTool paymentTool(int paymentToolId, CompleteHandler<PaymentTool, Throwable> callback) {
        return this.core.networkManager.request(this.composer.beneficiariesToolsTool(this.core.getBenificaryId(), paymentToolId), NetworkManager.MethodType.GET, null, PaymentTool.class, callback);
    }

    public void delete(int paymentToolId, CompleteErrorOnlyHandler<Throwable> callback) {
        this.core.networkManager.request(this.composer.beneficiariesToolsTool(this.core.getBenificaryId(), paymentToolId), NetworkManager.MethodType.DELETE, null, callback);
    }

    public RequestBuilder addNewPaymentToolRequest(@NonNull String returnUrl, @Nullable String paymentTypeId, @Nullable Boolean redirectToPaymentToolAddition) {
        String urlString = this.composer.beneficiary();
        String timestamp = NetworkManager.ISO8601TimeStamp.getISO8601TimeStamp(new Date());
        TreeMap<String, String> items = new TreeMap<String, String>();
        items.put("PhoneNumber", this.core.getBenificaryPhoneNumber());
        items.put("PlatformBeneficiaryId", this.core.getBenificaryId());
        items.put("PlatformId", this.core.getPlatformId());
        items.put("ReturnUrl", returnUrl);
        items.put("Timestamp", timestamp);
        items.put("Title", this.core.getBenificaryTitle());
        if (paymentTypeId != null) {
            items.put("PaymentTypeId", paymentTypeId);
        }
        if (redirectToPaymentToolAddition != null) {
            items.put("RedirectToPaymentToolAddition", redirectToPaymentToolAddition != false ? "true" : "false");
        }
        String signature = this.core.networkManager.makeSignatureForWeb(items);
        items.put("Signature", signature);
        ArrayList<String> params = new ArrayList<String>();
        for (Map.Entry entry : items.entrySet()) {
            params.add(String.format("%s=%s", entry.getKey(), Uri.encode((String)((String)entry.getValue()), (String)"UTF-8")));
        }
        String queryString = TextUtils.join((CharSequence)"&", params);
        System.out.print(queryString);
        Log.d((String)"REQUESTS", (String)queryString);
        RequestBuilder.Builder builder = RequestBuilder.newBuilder().setMethodType(NetworkManager.MethodType.POST).setSignature(signature).setTimestamp(timestamp).setUrlString(urlString).setHttpBody(queryString);
        return builder.build();
    }

    class Composer
    extends URLComposer {
        Composer() {
        }

        String beneficiary() {
            return Composer.getInstance().relativeToBase("v2/beneficiary");
        }

        String beneficiaries() {
            return Composer.getInstance().relativeToApi("beneficiaries");
        }

        String beneficiaries(String id) {
            return Composer.getInstance().relative(this.beneficiaries(), id);
        }

        String beneficiariesTools(String id) {
            return Composer.getInstance().relative(this.beneficiaries(id), "tools");
        }

        String beneficiariesToolsTool(String id, int card) {
            return Composer.getInstance().relative(this.beneficiariesTools(id), String.valueOf(card));
        }
    }
}

