/*
 * Decompiled with CFR 0.152.
 */
package com.wallacehub.utils.network;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.wallacehub.utils.logging.WHLog;

public class Network {
    public static final String TAG = Network.class.getSimpleName();
    public static final int CONNECTION_NONE = 0;
    public static final int CONNECTED = 1;
    public static final int CONNECTION_WIFI = 2;
    public static final int CONNECTION_MOBILE = 4;

    private Network() {
    }

    public static int hasNetworkConnection(Context context) {
        int returnValue = 0;
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (null != connectivityManager) {
            NetworkInfo[] netInfo;
            for (NetworkInfo ni : netInfo = connectivityManager.getAllNetworkInfo()) {
                if (!ni.isConnected()) continue;
                returnValue |= 1;
                if ("WIFI".equalsIgnoreCase(ni.getTypeName())) {
                    returnValue |= 2;
                    continue;
                }
                if (!"MOBILE".equalsIgnoreCase(ni.getTypeName())) continue;
                returnValue |= 4;
            }
        }
        return returnValue;
    }

    static {
        WHLog.LOG_LEVELS.put(TAG, 5);
    }
}

