/*
 * Decompiled with CFR 0.152.
 */
package com.wallacehub.utils.logging;

import com.wallacehub.utils.logging.RSLog;
import java.util.ArrayList;
import org.joda.time.Instant;

public class TimingLogger {
    private String m_tag;
    private String m_label;
    private ArrayList<Split> m_splits = new ArrayList();

    public TimingLogger(String tag, String label) {
        this.m_tag = tag;
        this.m_label = label;
        this.reset();
    }

    public void reset() {
        this.m_splits.clear();
        this.addSplit(null);
    }

    public void addSplit(String splitLabel) {
        this.m_splits.add(new Split(Instant.now(), splitLabel));
    }

    public void dumpAsIntervals() {
        Split first;
        RSLog.d(this.m_tag, this.m_label + ": begin");
        Split current = first = this.m_splits.get(0);
        Split prev = first;
        for (int i = 1; i < this.m_splits.size(); ++i) {
            current = this.m_splits.get(i);
            RSLog.d(this.m_tag, this.m_label + ":      " + current.splitTime.minus(prev.splitTime.getMillis()).getMillis() + " ms, " + current.splitLabel);
            prev = current;
        }
        RSLog.d(this.m_tag, this.m_label + ": end, total : " + current.splitTime.minus(first.splitTime.getMillis()).getMillis() + " ms");
    }

    public void dumpAsTimes() {
        Split first;
        RSLog.d(this.m_tag, this.m_label + ": begin");
        Split current = first = this.m_splits.get(0);
        for (int i = 0; i < this.m_splits.size(); ++i) {
            current = this.m_splits.get(i);
            RSLog.d(this.m_tag, this.m_label + ":      " + current.splitTime + " ms, " + current.splitLabel);
        }
        RSLog.d(this.m_tag, this.m_label + ": end, total : " + current.splitTime.minus(first.splitTime.getMillis()).getMillis() + " ms");
    }

    public void splitAndDumpAsIntervals(String splitLabel) {
        this.addSplit(splitLabel);
        this.dumpAsIntervals();
    }

    public void splitAndDumpAsTimes(String splitLabel) {
        this.addSplit(splitLabel);
        this.dumpAsTimes();
    }

    private class Split {
        Instant splitTime;
        String splitLabel;

        Split(Instant splitTime, String splitLabel) {
            this.splitTime = splitTime;
            this.splitLabel = splitLabel;
        }
    }
}

