/*
 * Decompiled with CFR 0.152.
 */
package com.wajahatkarim3.clapfab;

import android.animation.ArgbEvaluator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u000e\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001c\u0018\u0000 I2\u00020\u0001:\u0001IB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020'2\u0006\u0010*\u001a\u00020'J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\b\u00100\u001a\u00020,H\u0002J.\u00101\u001a\u00020'2\u0006\u0010(\u001a\u00020'2\u0006\u00102\u001a\u00020'2\u0006\u00103\u001a\u00020'2\u0006\u00104\u001a\u00020'2\u0006\u00105\u001a\u00020'J\u0010\u00106\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0014J\u0018\u00107\u001a\u00020,2\u0006\u00108\u001a\u00020\t2\u0006\u00109\u001a\u00020\tH\u0014J(\u0010:\u001a\u00020,2\u0006\u0010;\u001a\u00020\t2\u0006\u0010<\u001a\u00020\t2\u0006\u0010=\u001a\u00020\t2\u0006\u0010>\u001a\u00020\tH\u0014J\u0016\u0010?\u001a\u00020,2\u0006\u0010@\u001a\u00020\t2\u0006\u0010A\u001a\u00020\tJ\u0016\u0010B\u001a\u00020,2\u0006\u0010C\u001a\u00020\t2\u0006\u0010D\u001a\u00020\tJ\b\u0010E\u001a\u00020,H\u0002J\b\u0010F\u001a\u00020,H\u0002J\b\u0010G\u001a\u00020,H\u0002J\b\u0010H\u001a\u00020,H\u0002R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0018@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lcom/wajahatkarim3/clapfab/DotsView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "COLOR_1", "COLOR_2", "COLOR_3", "COLOR_4", "argbEvaluator", "Landroid/animation/ArgbEvaluator;", "centerX", "centerY", "circlePaints", "", "Landroid/graphics/Paint;", "[Landroid/graphics/Paint;", "currentDotSize1", "", "currentDotSize2", "currentProgress", "getCurrentProgress", "()F", "setCurrentProgress", "(F)V", "currentRadius1", "currentRadius2", "heightInternal", "maxDotSize", "maxInnerDotsRadius", "maxOuterDotsRadius", "widthInternal", "clamp", "", "value", "low", "high", "drawInnerDotsFrame", "", "canvas", "Landroid/graphics/Canvas;", "drawOuterDotsFrame", "init", "mapValueFromRangeToRange", "fromLow", "fromHigh", "toLow", "toHigh", "onDraw", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onSizeChanged", "w", "h", "oldw", "oldh", "setColors", "primaryColor", "secondaryColor", "setSize", "width", "height", "updateDotsAlpha", "updateDotsPaints", "updateInnerDotsPosition", "updateOuterDotsPosition", "Companion", "clapfab_release"})
public final class DotsView
extends View {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int COLOR_1;
    private int COLOR_2;
    private int COLOR_3;
    private int COLOR_4;
    private int widthInternal;
    private int heightInternal;
    @NotNull
    private final Paint[] circlePaints;
    private int centerX;
    private int centerY;
    private float maxOuterDotsRadius;
    private float maxInnerDotsRadius;
    private float maxDotSize;
    private float currentProgress;
    private float currentRadius1;
    private float currentDotSize1;
    private float currentDotSize2;
    private float currentRadius2;
    @NotNull
    private final ArgbEvaluator argbEvaluator;
    private static final int DOTS_COUNT = 7;
    private static final int OUTER_DOTS_POSITION_ANGLE = 51;
    @NotNull
    private static final Property<DotsView, Float> DOTS_PROGRESS;

    public final float getCurrentProgress() {
        return this.currentProgress;
    }

    public final void setCurrentProgress(float currentProgress) {
        this.currentProgress = currentProgress;
        this.updateInnerDotsPosition();
        this.updateOuterDotsPosition();
        this.updateDotsPaints();
        this.updateDotsAlpha();
        this.postInvalidate();
    }

    public DotsView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.COLOR_1 = -16121;
        this.COLOR_2 = -26624;
        this.COLOR_3 = -43230;
        this.COLOR_4 = -769226;
        this.circlePaints = new Paint[4];
        this.argbEvaluator = new ArgbEvaluator();
        this.init();
    }

    public DotsView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.COLOR_1 = -16121;
        this.COLOR_2 = -26624;
        this.COLOR_3 = -43230;
        this.COLOR_4 = -769226;
        this.circlePaints = new Paint[4];
        this.argbEvaluator = new ArgbEvaluator();
        this.init();
    }

    public DotsView(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
        this.COLOR_1 = -16121;
        this.COLOR_2 = -26624;
        this.COLOR_3 = -43230;
        this.COLOR_4 = -769226;
        this.circlePaints = new Paint[4];
        this.argbEvaluator = new ArgbEvaluator();
        this.init();
    }

    private final void init() {
        int n = 0;
        int n2 = this.circlePaints.length + -1;
        if (n <= n2) {
            do {
                int i = n++;
                this.circlePaints[i] = new Paint();
                Paint paint = this.circlePaints[i];
                if (paint != null) {
                    paint.setStyle(Paint.Style.FILL);
                }
                paint = this.circlePaints[i];
                if (paint == null) continue;
                paint.setAntiAlias(true);
            } while (n <= n2);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.centerX = w / 2;
        this.centerY = h / 2;
        this.maxDotSize = 5.0f;
        this.maxOuterDotsRadius = (float)(w / 2) - this.maxDotSize * (float)2;
        this.maxInnerDotsRadius = 0.8f * this.maxOuterDotsRadius;
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        this.drawOuterDotsFrame(canvas);
        this.drawInnerDotsFrame(canvas);
    }

    private final void drawOuterDotsFrame(Canvas canvas) {
        int n = 0;
        int n2 = DOTS_COUNT;
        if (n < n2) {
            do {
                int i = n++;
                int cX = (int)((double)this.centerX + (double)this.currentRadius1 * Math.cos((double)i * (double)OUTER_DOTS_POSITION_ANGLE * Math.PI / (double)180));
                int cY = (int)((double)this.centerY + (double)this.currentRadius1 * Math.sin((double)i * (double)OUTER_DOTS_POSITION_ANGLE * Math.PI / (double)180));
                float f = cX;
                float f2 = cY;
                Paint paint = this.circlePaints[i % this.circlePaints.length];
                Intrinsics.checkNotNull((Object)paint);
                canvas.drawCircle(f, f2, this.currentDotSize1, paint);
            } while (n < n2);
        }
    }

    private final void drawInnerDotsFrame(Canvas canvas) {
        int n = 0;
        int n2 = DOTS_COUNT;
        if (n < n2) {
            do {
                int i = n++;
                int cX = (int)((double)this.centerX + (double)this.currentRadius2 * Math.cos((double)(i * OUTER_DOTS_POSITION_ANGLE - 10) * Math.PI / (double)180));
                int cY = (int)((double)this.centerY + (double)this.currentRadius2 * Math.sin((double)(i * OUTER_DOTS_POSITION_ANGLE - 10) * Math.PI / (double)180));
                float f = cX;
                float f2 = cY;
                Paint paint = this.circlePaints[(i + 1) % this.circlePaints.length];
                Intrinsics.checkNotNull((Object)paint);
                canvas.drawCircle(f, f2, this.currentDotSize2, paint);
            } while (n < n2);
        }
    }

    private final void updateInnerDotsPosition() {
        this.currentRadius2 = this.currentProgress < 0.3f ? (float)this.mapValueFromRangeToRange(this.currentProgress, 0.0, 0.3, 0.0, this.maxInnerDotsRadius) : this.maxInnerDotsRadius;
        this.currentDotSize2 = this.currentProgress == 0.0f ? 0.0f : ((double)this.currentProgress < 0.2 ? this.maxDotSize : ((double)this.currentProgress < 0.5 ? (float)this.mapValueFromRangeToRange(this.currentProgress, 0.2, 0.5, this.maxDotSize, 0.3 * (double)this.maxDotSize) : (float)this.mapValueFromRangeToRange(this.currentProgress, 0.5, 1.0, this.maxDotSize * 0.3f, 0.0)));
    }

    private final void updateOuterDotsPosition() {
        this.currentRadius1 = this.currentProgress < 0.3f ? (float)this.mapValueFromRangeToRange(this.currentProgress, 0.0, 0.3, 0.0, this.maxOuterDotsRadius * 0.8f) : (float)this.mapValueFromRangeToRange(this.currentProgress, 0.3, 1.0, 0.8f * this.maxOuterDotsRadius, this.maxOuterDotsRadius);
        this.currentDotSize1 = this.currentProgress == 0.0f ? 0.0f : ((double)this.currentProgress < 0.7 ? this.maxDotSize : (float)this.mapValueFromRangeToRange(this.currentProgress, 0.7, 1.0, this.maxDotSize, 0.0));
    }

    private final void updateDotsPaints() {
        if (this.currentProgress < 0.5f) {
            Object object;
            float progress = (float)this.mapValueFromRangeToRange(this.currentProgress, 0.0, 0.5, 0.0, 1.0);
            Paint paint = this.circlePaints[0];
            if (paint != null) {
                object = this.argbEvaluator.evaluate(progress, (Object)this.COLOR_1, (Object)this.COLOR_2);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                paint.setColor(((Integer)object).intValue());
            }
            if ((paint = this.circlePaints[1]) != null) {
                object = this.argbEvaluator.evaluate(progress, (Object)this.COLOR_2, (Object)this.COLOR_3);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                paint.setColor(((Integer)object).intValue());
            }
            if ((paint = this.circlePaints[2]) != null) {
                object = this.argbEvaluator.evaluate(progress, (Object)this.COLOR_3, (Object)this.COLOR_4);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                paint.setColor(((Integer)object).intValue());
            }
            if ((paint = this.circlePaints[3]) != null) {
                object = this.argbEvaluator.evaluate(progress, (Object)this.COLOR_4, (Object)this.COLOR_1);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                paint.setColor(((Integer)object).intValue());
            }
        } else {
            Object object;
            float progress = (float)this.mapValueFromRangeToRange(this.currentProgress, 0.5, 1.0, 0.0, 1.0);
            Paint paint = this.circlePaints[0];
            if (paint != null) {
                object = this.argbEvaluator.evaluate(progress, (Object)this.COLOR_2, (Object)this.COLOR_3);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                paint.setColor(((Integer)object).intValue());
            }
            if ((paint = this.circlePaints[1]) != null) {
                object = this.argbEvaluator.evaluate(progress, (Object)this.COLOR_3, (Object)this.COLOR_4);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                paint.setColor(((Integer)object).intValue());
            }
            if ((paint = this.circlePaints[2]) != null) {
                object = this.argbEvaluator.evaluate(progress, (Object)this.COLOR_4, (Object)this.COLOR_1);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                paint.setColor(((Integer)object).intValue());
            }
            if ((paint = this.circlePaints[3]) != null) {
                object = this.argbEvaluator.evaluate(progress, (Object)this.COLOR_1, (Object)this.COLOR_2);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                paint.setColor(((Integer)object).intValue());
            }
        }
    }

    public final void setColors(int primaryColor, int secondaryColor) {
        this.COLOR_1 = primaryColor;
        this.COLOR_2 = secondaryColor;
        this.COLOR_3 = primaryColor;
        this.COLOR_4 = secondaryColor;
        this.invalidate();
    }

    private final void updateDotsAlpha() {
        float progress = (float)this.clamp(this.currentProgress, 0.6, 1.0);
        int alpha = (int)this.mapValueFromRangeToRange(progress, 0.6, 1.0, 255.0, 0.0);
        Paint paint = this.circlePaints[0];
        if (paint != null) {
            paint.setAlpha(alpha);
        }
        paint = this.circlePaints[1];
        if (paint != null) {
            paint.setAlpha(alpha);
        }
        paint = this.circlePaints[2];
        if (paint != null) {
            paint.setAlpha(alpha);
        }
        paint = this.circlePaints[3];
        if (paint != null) {
            paint.setAlpha(alpha);
        }
    }

    public final void setSize(int width, int height) {
        this.widthInternal = width;
        this.heightInternal = height;
        this.invalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.widthInternal != 0 && this.heightInternal != 0) {
            this.setMeasuredDimension(this.widthInternal, this.heightInternal);
        }
    }

    public final double mapValueFromRangeToRange(double value, double fromLow, double fromHigh, double toLow, double toHigh) {
        return toLow + (value - fromLow) / (fromHigh - fromLow) * (toHigh - toLow);
    }

    public final double clamp(double value, double low, double high) {
        return Math.min(Math.max(value, low), high);
    }

    static {
        Class<Float> clazz = Float.TYPE;
        DOTS_PROGRESS = (Property)new Property<DotsView, Float>(clazz){

            @NotNull
            public Float get(@NotNull DotsView object) {
                Intrinsics.checkNotNullParameter((Object)((Object)object), (String)"object");
                return Float.valueOf(object.getCurrentProgress());
            }

            public void set(@NotNull DotsView object, float value) {
                Intrinsics.checkNotNullParameter((Object)((Object)object), (String)"object");
                object.setCurrentProgress(value);
            }
        };
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/wajahatkarim3/clapfab/DotsView$Companion;", "", "()V", "DOTS_COUNT", "", "DOTS_PROGRESS", "Landroid/util/Property;", "Lcom/wajahatkarim3/clapfab/DotsView;", "", "getDOTS_PROGRESS", "()Landroid/util/Property;", "OUTER_DOTS_POSITION_ANGLE", "clapfab_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Property<DotsView, Float> getDOTS_PROGRESS() {
            return DOTS_PROGRESS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

