package com.vungle.ads.internal.util

import android.content.Context
import android.content.res.Configuration
import android.content.res.Resources
import android.webkit.WebView
import com.vungle.ads.internal.presenter.WebViewManager

object ViewUtility {
    fun dpToPixels(context: Context, dp: Int): Int {
        val scale = context.resources.displayMetrics.density
        return (dp * scale + 0.5f).toInt()
    }

    @Throws(InstantiationException::class)
    fun getWebView(context: Context, eventId: String?): WebView {
        return try {
            WebViewManager.getOrCreateWebView(context, eventId)
        } catch (e: Resources.NotFoundException) {
            throw InstantiationException("Cannot instantiate WebView due to " +
                    "Resources.NotFoundException: $e.message")
        } catch (e: Exception) {
            throw InstantiationException(e.message)
        }
    }

    /**
     * Get the device width and height in DIP by device orientation
     * @param context
     * @param orientation 0 for current orientation, 1 for portrait, 2 for landscape
     * @return device width and height in DIP.
     */
    fun getDeviceWidthAndHeightWithOrientation(context: Context, orientation: Int): Pair<Int, Int> {
        val resource = context.applicationContext.resources
        val displayMetrics = resource.displayMetrics
        val configuration = resource.configuration
        val curOrientation = configuration.orientation

        val requiredOrientation = if (orientation == Configuration.ORIENTATION_UNDEFINED) {
            curOrientation
        } else {
            orientation
        }

        return if (requiredOrientation == curOrientation) Pair(
            Math.round(displayMetrics.widthPixels.toFloat() / displayMetrics.density),
            Math.round(displayMetrics.heightPixels.toFloat() / displayMetrics.density)
        )
        else Pair(
            Math.round(displayMetrics.heightPixels.toFloat() / displayMetrics.density),
            Math.round(displayMetrics.widthPixels.toFloat() / displayMetrics.density)
        )
    }

}
