package com.vungle.ads.internal.util

import android.content.Context
import android.os.Build
import android.webkit.URLUtil
import java.io.File

internal object Utils {
    fun isUrlValid(url: String?): Boolean {
        return !url.isNullOrEmpty() && (URLUtil.isHttpsUrl(url) || URLUtil.isHttpUrl(url))
    }

    fun isOSVersionInvalid(): Boolean {
        return Build.VERSION.SDK_INT < Build.VERSION_CODES.N_MR1
    }

    private fun getFolderSize(dir: File): Long {
        var size = 0L
        if (dir.exists()) {
            dir.walkTopDown().forEach { file ->
                if (file.isFile) {
                    size += file.length()
                }
            }
        }
        return size
    }

    fun getWebViewDataSize(context: Context): Long {
        var totalSize = 0L
        try {
            val appWebViewDir = File(context.applicationInfo.dataDir, "app_webview")
            if (appWebViewDir.exists()) {
                totalSize += getFolderSize(appWebViewDir)
            }

            val cacheDir = context.cacheDir
            if (cacheDir.exists()) {
                totalSize += getFolderSize(cacheDir.resolve("webviewCache"))
            }

        } catch (e: Exception) {
            Logger.e("WebViewSize", "Error reading WebView data size: ${e.message}")
        }
        return totalSize
    }
}
