package com.vungle.ads.internal.util

import android.content.Context
import android.os.StatFs
import java.io.File

class PathProvider(val context: Context) {
    /** root directory for Vungle */
    private val vungleDir: File = File(context.noBackupFilesDir, VUNGLE_FOLDER)

    private val vmDir: File = File(
        vungleDir,
        VM_FOLDER
    )
    private val cleverCacheDir: File = File(
        vungleDir,
        CLEVER_CACHE_FOLDER
    )

    companion object {
        private const val VUNGLE_FOLDER = "vungle_cache"
        private const val VM_FOLDER = "adAssets"
        private const val CLEVER_CACHE_FOLDER = "clever_cache"
        private const val UNKNOWN_SIZE = -1L
    }

    init {
        listOf(vungleDir, vmDir, cleverCacheDir).forEach {
            if (!it.exists()) {
                it.mkdirs()
            }
        }
    }

    /** @return root directory for vungle data */
    fun getVungleDir(): File {
        if (!vungleDir.exists()) {
            vungleDir.mkdirs()
        }
        return vungleDir
    }

    /** @return root directory for clever cache */
    fun getCleverCacheDir(): File {
        if (!cleverCacheDir.exists()) {
            cleverCacheDir.mkdirs()
        }
        return cleverCacheDir
    }

    /** @return root directory for vm assets */
    fun getVmDir(): File {
        if (!vmDir.exists()) {
            vmDir.mkdirs()
        }
        return vmDir
    }

    /** @return directory for assets of specific ad(determined by adId(eventId)) */
    fun getDownloadsDirForAd(adId: String?): File? {
        if (adId.isNullOrEmpty()) {
            return null
        }
        val vmDirForAd = getVmDir()
        val adDir = File(vmDirForAd, adId)
        if (!adDir.exists()) {
            adDir.mkdirs()
        }
        return adDir
    }

    fun getSharedPrefsDir(): File = context.noBackupFilesDir

    fun getUnclosedAdFile(name: String): File {
        return File(getSharedPrefsDir(), name)
    }

    fun getAvailableBytes(path: String): Long {
        var bytesAvailable: Long = UNKNOWN_SIZE
        val stats: StatFs?
        try {
            stats = StatFs(path)

            bytesAvailable = stats.availableBytes
        } catch (e: IllegalArgumentException) {
            Logger.w("PathProvider", "Failed to get available bytes ${e.message}")
        }

        return bytesAvailable
    }
}
