package com.vungle.ads.internal.network

import com.vungle.ads.internal.util.LogEntry


class TpatRequest private constructor(
    val url: String,
    val method: HttpMethod,
    val headers: Map<String, String>?,
    val body: String?,
    val priorityRetry: Boolean?,
    val priorityRetryCount: Int,
    val regularRetry: Boolean,
    val regularRetryCount: Int,
    val tpatKey: String?,
    val logEntry: LogEntry?,
) {

    companion object {
        private const val PRIORITY_MAX_RETRY_COUNT = 3
        private const val REGULAR_MAX_RETRY_COUNT = 5
    }

    internal class Builder(val url: String) {
        private var method: HttpMethod = HttpMethod.GET
        private var headers: Map<String, String>? = null
        private var body: String? = null
        private var priorityRetry: Boolean? = null
        private var priorityRetryCount: Int = PRIORITY_MAX_RETRY_COUNT
        private var regularRetry: Boolean = true
        private var regularRetryCount: Int = REGULAR_MAX_RETRY_COUNT
        private var tpatKey: String? = null
        private var logEntry: LogEntry? = null

        fun get() = apply { this.method = HttpMethod.GET }

        fun post() = apply { this.method = HttpMethod.POST }

        fun method(method: HttpMethod) = apply { this.method = method }

        fun headers(headers: Map<String, String>?) = apply { this.headers = headers }

        fun body(body: String?) = apply { this.body = body }

        fun priorityRetry(priorityRetry: Boolean) = apply { this.priorityRetry = priorityRetry }

        fun priorityRetryCount(priorityRetryCount: Int) = apply {
            this.priorityRetryCount = priorityRetryCount
        }

        fun regularRetry(regularRetry: Boolean) = apply { this.regularRetry = regularRetry }

        fun regularRetryCount(regularRetryCount: Int) = apply {
            this.regularRetryCount = regularRetryCount
        }

        fun withLogEntry(logEntry: LogEntry?) = apply { this.logEntry = logEntry }

        fun tpatKey(tpatKey: String?) = apply { this.tpatKey = tpatKey }

        fun build(): TpatRequest {
            return TpatRequest(
                url,
                method,
                headers, body,
                priorityRetry,
                priorityRetryCount,
                regularRetry,
                regularRetryCount,
                tpatKey,
                logEntry,
            )
        }
    }
}
