package com.vungle.ads.internal.platform

import android.content.Context
import android.view.View
import com.vungle.ads.internal.util.Logger
import android.webkit.WebSettings
import android.webkit.WebView
import androidx.core.util.Consumer
import com.vungle.ads.BuildConfig
import com.vungle.ads.internal.model.AdPayload

object WebViewUtil {

    private const val TAG = "WebViewUtil"

    fun getUserAgent(context: Context, consumer: Consumer<String?>) {
        runCatching {
            WebSettings.getDefaultUserAgent(context)
        }.onSuccess {
            consumer.accept(it)
        }.onFailure { e ->
            Logger.e(TAG, "Failed to get user agent", e)
            consumer.accept(null)
        }
    }

    fun applyWebSettings(webView: WebView, webViewSettings: AdPayload.WebViewSettings?) {
        val webSettings = webView.settings
        webSettings.builtInZoomControls = false
        webSettings.javaScriptEnabled = true
        webSettings.loadWithOverviewMode = true
        webSettings.saveFormData = true
        webSettings.useWideViewPort = false
        webSettings.allowFileAccess = true
        webSettings.allowFileAccessFromFileURLs =
            webViewSettings?.allowFileAccessFromFileUrls ?: false
        webSettings.allowUniversalAccessFromFileURLs =
            webViewSettings?.allowUniversalAccessFromFileUrls ?: false
        webView.visibility = View.INVISIBLE
        webSettings.mediaPlaybackRequiresUserGesture = false
        if (BuildConfig.DEBUG) {
            WebView.setWebContentsDebuggingEnabled(true)
        }
    }
}
