package com.vungle.ads.internal.downloader

import android.util.Base64
import androidx.annotation.WorkerThread
import com.vungle.ads.internal.Constants.LO_PRIVACY_ICON_STRING
import com.vungle.ads.internal.Constants.PRIVACY_ICON_FILE_NAME
import java.io.File
import java.io.FileOutputStream

internal object DefaultPrivacyIconInjector {

    @WorkerThread
    fun injectPrivacyIcon(dir: File): File? {
        val privacyIconFile = File(dir, PRIVACY_ICON_FILE_NAME)
        if (privacyIconFile.exists()) {
            return privacyIconFile
        }

        if (writePrivacyFileFromString(privacyIconFile)) {
            return privacyIconFile
        }

        return null
    }

    private fun writePrivacyFileFromString(file: File): Boolean {
        return runCatching {
            val bytes = Base64.decode(LO_PRIVACY_ICON_STRING, Base64.DEFAULT)
            FileOutputStream(file).use {
                it.write(bytes)
            }
            true
        }.getOrDefault(false)
    }

}
